/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openjpa.lib.graph.Edge;

public class Graph {
    private final Map<Object, Collection<Edge>> _nodes = new LinkedHashMap<Object, Collection<Edge>>();

    public void clear() {
        this._nodes.clear();
    }

    public boolean containsNode(Object node) {
        return this._nodes.containsKey(node);
    }

    public Collection<Object> getNodes() {
        return this._nodes.keySet();
    }

    public void addNode(Object node) {
        if (node == null) {
            throw new NullPointerException("node = null");
        }
        if (!this.containsNode(node)) {
            this._nodes.put(node, null);
        }
    }

    public boolean removeNode(Object node) {
        boolean rem = this.containsNode(node);
        if (rem) {
            Collection<Edge> edges = this.getEdgesTo(node);
            for (Edge edge : edges) {
                this.removeEdge(edge);
            }
            this._nodes.remove(node);
        }
        return rem;
    }

    public Collection<Edge> getEdges() {
        HashSet<Edge> all = new HashSet<Edge>();
        for (Collection<Edge> edges : this._nodes.values()) {
            if (edges == null) continue;
            all.addAll(edges);
        }
        return all;
    }

    public Collection<Edge> getEdgesFrom(Object node) {
        Collection<Edge> edges = this._nodes.get(node);
        if (edges == null) {
            edges = Collections.emptyList();
        }
        return edges;
    }

    public Collection<Edge> getEdgesTo(Object node) {
        Collection<Edge> edges = this.getEdges();
        ArrayList<Edge> to = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (!edge.isTo(node)) continue;
            to.add(edge);
        }
        return to;
    }

    public Collection<Edge> getEdges(Object from, Object to) {
        Collection<Edge> edges = this.getEdgesFrom(from);
        ArrayList<Edge> matches = new ArrayList<Edge>(edges.size());
        for (Edge edge : edges) {
            if (!edge.isTo(to)) continue;
            matches.add(edge);
        }
        return matches;
    }

    public void addEdge(Edge edge) {
        if (!this.containsNode(edge.getTo())) {
            throw new IllegalArgumentException(edge.getTo().toString());
        }
        if (!this.containsNode(edge.getFrom())) {
            throw new IllegalArgumentException(edge.getFrom().toString());
        }
        Collection<Edge> from = this._nodes.get(edge.getFrom());
        if (from == null) {
            from = new ArrayList<Edge>(3);
            this._nodes.put(edge.getFrom(), from);
        }
        from.add(edge);
        if (!edge.isDirected() && !edge.getFrom().equals(edge.getTo())) {
            Collection<Edge> to = this._nodes.get(edge.getTo());
            if (to == null) {
                to = new ArrayList<Edge>(3);
                this._nodes.put(edge.getTo(), to);
            }
            to.add(edge);
        }
    }

    public boolean removeEdge(Edge edge) {
        Collection<Edge> edges = this._nodes.get(edge.getFrom());
        if (edges == null) {
            return false;
        }
        boolean rem = edges.remove(edge);
        if (rem && !edge.isDirected() && (edges = this._nodes.get(edge.getTo())) != null) {
            edges.remove(edge);
        }
        return rem;
    }

    public void clearTraversal() {
        for (Collection<Edge> edges : this._nodes.values()) {
            if (edges == null) continue;
            for (Edge edge : edges) {
                edge.clearTraversal();
            }
        }
    }
}

