/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.apache.commons.lang3.StringUtils;

public class HistoricDetailVariableInstanceUpdateEntity
extends HistoricDetailEntity
implements ValueFields,
HistoricVariableUpdate,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected int revision;
    protected String name;
    protected VariableType variableType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected final ByteArrayRef byteArrayRef = new ByteArrayRef();
    protected Object cachedValue;

    protected HistoricDetailVariableInstanceUpdateEntity() {
    }

    public static HistoricDetailVariableInstanceUpdateEntity copyAndInsert(VariableInstanceEntity variableInstance) {
        HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = new HistoricDetailVariableInstanceUpdateEntity();
        historicVariableUpdate.processInstanceId = variableInstance.getProcessInstanceId();
        historicVariableUpdate.executionId = variableInstance.getExecutionId();
        historicVariableUpdate.taskId = variableInstance.getTaskId();
        historicVariableUpdate.time = ClockUtil.getCurrentTime();
        historicVariableUpdate.revision = variableInstance.getRevision();
        historicVariableUpdate.name = variableInstance.getName();
        historicVariableUpdate.variableType = variableInstance.getType();
        historicVariableUpdate.textValue = variableInstance.getTextValue();
        historicVariableUpdate.textValue2 = variableInstance.getTextValue2();
        historicVariableUpdate.doubleValue = variableInstance.getDoubleValue();
        historicVariableUpdate.longValue = variableInstance.getLongValue();
        if (variableInstance.getBytes() != null) {
            String byteArrayName = "hist.detail.var-" + variableInstance.getName();
            historicVariableUpdate.byteArrayRef.setValue(byteArrayName, variableInstance.getBytes());
        }
        Context.getCommandContext().getDbSqlSession().insert(historicVariableUpdate);
        return historicVariableUpdate;
    }

    @Override
    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public void delete() {
        super.delete();
        this.byteArrayRef.delete();
    }

    @Override
    public Object getPersistentState() {
        return HistoricDetailVariableInstanceUpdateEntity.class;
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public byte[] getBytes() {
        return this.byteArrayRef.getBytes();
    }

    @Override
    public void setBytes(byte[] bytes) {
        throw new UnsupportedOperationException("HistoricDetailVariableInstanceUpdateEntity is immutable");
    }

    @Override
    @Deprecated
    public String getByteArrayValueId() {
        return this.byteArrayRef.getId();
    }

    @Override
    @Deprecated
    public ByteArrayEntity getByteArrayValue() {
        return this.byteArrayRef.getEntity();
    }

    @Override
    @Deprecated
    public void setByteArrayValue(byte[] bytes) {
        this.setBytes(bytes);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricDetailVariableInstanceUpdateEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", type=").append(this.variableType != null ? this.variableType.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

