/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.xpointer;

import java.io.IOException;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.xpointer.AbstractPointerPart;
import org.apache.cocoon.sax.xpointer.XPointerContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class ShorthandPart
extends AbstractPointerPart {
    private static final String XMLNS_NAMESPACE_98 = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NAMESPACE_00 = "http://www.w3.org/2000/xmlns/";
    private static final String ID = "id";
    private final String shorthand;
    private SAXConsumer saxConsumer;
    private boolean matching = false;
    private int matchingLevel = 0;

    public ShorthandPart(String shorthand) {
        this.shorthand = shorthand;
    }

    public void setUp(XPointerContext xpointerContext) throws SAXException, IOException {
        this.saxConsumer = xpointerContext.getSaxConsumer();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.matching) {
            this.saxConsumer.characters(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.saxConsumer.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.matching) {
            this.saxConsumer.endElement(uri, localName, qName);
            --this.matchingLevel;
            if (this.matchingLevel == 0) {
                this.matching = false;
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.matching) {
            this.saxConsumer.endPrefixMapping(prefix);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.matching) {
            this.saxConsumer.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.matching) {
            this.saxConsumer.processingInstruction(target, data);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.matching) {
            this.saxConsumer.skippedEntity(name);
        }
    }

    public void startDocument() throws SAXException {
        this.saxConsumer.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.matching) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeURI = atts.getURI(i);
                String attributeName = atts.getLocalName(i);
                String attributeValue = atts.getValue(i);
                if (attributeURI != null && attributeURI.length() != 0 && !XMLNS_NAMESPACE_98.equals(attributeURI) && !XMLNS_NAMESPACE_00.equals(attributeURI) || !ID.equalsIgnoreCase(attributeName) || !this.shorthand.equals(attributeValue)) continue;
                this.matching = true;
                this.matchingLevel = 0;
                break;
            }
        }
        if (this.matching) {
            this.saxConsumer.startElement(uri, localName, qName, atts);
            ++this.matchingLevel;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.matching) {
            this.saxConsumer.startPrefixMapping(prefix, uri);
        }
    }
}

