/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import org.apache.cocoon.sax.component.SchemaValidationException;
import org.apache.commons.logging.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SchemaErrorHandler
implements ErrorHandler {
    private final Log logger;
    private final String schemaUri;

    public SchemaErrorHandler(Log logger, String schemaUri) {
        this.logger = logger;
        this.schemaUri = schemaUri;
    }

    public void error(SAXParseException ex) throws SAXException {
        throw new SchemaValidationException("Validation with schema " + this.schemaUri + " failed with error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw new SchemaValidationException("Validation with schema " + this.schemaUri + " failed with fatal error", ex);
    }

    public void warning(SAXParseException ex) throws SAXException {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(ex.getMessage() + " at " + this.schemaUri));
        }
    }
}

