/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.resource.IResourceStream;

public class HtmlHeaderResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    public static final String HEAD = "head";

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag.getId().equals("_header_")) {
            return this.newHtmlHeaderContainer("_header_" + container.getPage().getAutoIndex());
        }
        if (tag instanceof WicketTag && ((WicketTag)tag).isHeadTag()) {
            if (container instanceof WebPage) {
                HtmlHeaderContainer header = this.newHtmlHeaderContainer("_header_" + container.getPage().getAutoIndex());
                TransparentWebMarkupContainer header2 = new TransparentWebMarkupContainer("_header_");
                header2.setRenderBodyOnly(true);
                header.add(header2);
                return header;
            }
            if (container instanceof HtmlHeaderContainer) {
                TransparentWebMarkupContainer header = new TransparentWebMarkupContainer("_header_");
                header.setRenderBodyOnly(true);
                return header;
            }
            Page page = container.getPage();
            String pageClassName = page != null ? page.getClass().getName() : "unknown";
            IResourceStream stream = markupStream.getResource();
            String streamName = stream != null ? stream.toString() : "unknown";
            throw new MarkupException("Mis-placed <wicket:head>. <wicket:head> must be outside of <wicket:panel>, <wicket:border>, and <wicket:extend>. Error occured while rendering page: " + pageClassName + " using markup stream: " + streamName);
        }
        return null;
    }

    protected HtmlHeaderContainer newHtmlHeaderContainer(String id) {
        return new HtmlHeaderContainer(id);
    }
}

