/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.activiti.engine.impl.persistence.entity.AttachmentEntityManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntityManager;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.GroupIdentityManager;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.MembershipIdentityManager;
import org.activiti.engine.impl.persistence.entity.ModelEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti.engine.impl.persistence.entity.PropertyEntityManager;
import org.activiti.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.engine.impl.persistence.entity.TableDataManager;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.UserIdentityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static Logger log = LoggerFactory.getLogger(CommandContext.class);
    protected Command<?> command;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception = null;
    protected LinkedList<AtomicOperation> nextOperations = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(AtomicOperation executionOperation, InterpretableExecution execution) {
        this.nextOperations.add(executionOperation);
        if (this.nextOperations.size() == 1) {
            try {
                Context.setExecutionContext(execution);
                while (!this.nextOperations.isEmpty()) {
                    AtomicOperation currentOperation = this.nextOperations.removeFirst();
                    if (log.isTraceEnabled()) {
                        log.trace("AtomicOperation: {} on {}", (Object)currentOperation, (Object)this);
                    }
                    currentOperation.execute(execution);
                }
            }
            finally {
                Context.removeExecutionContext();
            }
        }
    }

    public CommandContext(Command<?> command, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.command = command;
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContext = processEngineConfiguration.getTransactionContextFactory().openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block32: {
            try {
                try {
                    try {
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block32;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                if (this.exception instanceof JobNotFoundException || this.exception instanceof ActivitiTaskAlreadyClaimedException) {
                                    log.info("Error while closing command context", this.exception);
                                } else if (this.exception instanceof ActivitiOptimisticLockingException) {
                                    log.debug("Optimistic locking exception : " + this.exception);
                                } else {
                                    log.error("Error while closing command context", this.exception);
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        if (this.exception instanceof JobNotFoundException || this.exception instanceof ActivitiTaskAlreadyClaimedException) {
                            log.info("Error while closing command context", this.exception);
                        } else if (this.exception instanceof ActivitiOptimisticLockingException) {
                            log.debug("Optimistic locking exception : " + this.exception);
                        } else {
                            log.error("Error while closing command context", this.exception);
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (!(this.exception instanceof RuntimeException)) throw new ActivitiException("exception while executing command " + this.command, this.exception);
        throw (RuntimeException)this.exception;
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            LogMDC.putMDCExecution(Context.getExecutionContext().getExecution());
            log.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
            LogMDC.clear();
        }
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new ActivitiException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession();
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DeploymentEntityManager getDeploymentEntityManager() {
        return this.getSession(DeploymentEntityManager.class);
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.getSession(ResourceEntityManager.class);
    }

    public ByteArrayEntityManager getByteArrayEntityManager() {
        return this.getSession(ByteArrayEntityManager.class);
    }

    public ProcessDefinitionEntityManager getProcessDefinitionEntityManager() {
        return this.getSession(ProcessDefinitionEntityManager.class);
    }

    public ModelEntityManager getModelEntityManager() {
        return this.getSession(ModelEntityManager.class);
    }

    public ExecutionEntityManager getExecutionEntityManager() {
        return this.getSession(ExecutionEntityManager.class);
    }

    public TaskEntityManager getTaskEntityManager() {
        return this.getSession(TaskEntityManager.class);
    }

    public IdentityLinkEntityManager getIdentityLinkEntityManager() {
        return this.getSession(IdentityLinkEntityManager.class);
    }

    public VariableInstanceEntityManager getVariableInstanceEntityManager() {
        return this.getSession(VariableInstanceEntityManager.class);
    }

    public HistoricProcessInstanceEntityManager getHistoricProcessInstanceEntityManager() {
        return this.getSession(HistoricProcessInstanceEntityManager.class);
    }

    public HistoricDetailEntityManager getHistoricDetailEntityManager() {
        return this.getSession(HistoricDetailEntityManager.class);
    }

    public HistoricVariableInstanceEntityManager getHistoricVariableInstanceEntityManager() {
        return this.getSession(HistoricVariableInstanceEntityManager.class);
    }

    public HistoricActivityInstanceEntityManager getHistoricActivityInstanceEntityManager() {
        return this.getSession(HistoricActivityInstanceEntityManager.class);
    }

    public HistoricTaskInstanceEntityManager getHistoricTaskInstanceEntityManager() {
        return this.getSession(HistoricTaskInstanceEntityManager.class);
    }

    public HistoricIdentityLinkEntityManager getHistoricIdentityLinkEntityManager() {
        return this.getSession(HistoricIdentityLinkEntityManager.class);
    }

    public JobEntityManager getJobEntityManager() {
        return this.getSession(JobEntityManager.class);
    }

    public UserIdentityManager getUserIdentityManager() {
        return this.getSession(UserIdentityManager.class);
    }

    public GroupIdentityManager getGroupIdentityManager() {
        return this.getSession(GroupIdentityManager.class);
    }

    public IdentityInfoEntityManager getIdentityInfoEntityManager() {
        return this.getSession(IdentityInfoEntityManager.class);
    }

    public MembershipIdentityManager getMembershipIdentityManager() {
        return this.getSession(MembershipIdentityManager.class);
    }

    public AttachmentEntityManager getAttachmentEntityManager() {
        return this.getSession(AttachmentEntityManager.class);
    }

    public TableDataManager getTableDataManager() {
        return this.getSession(TableDataManager.class);
    }

    public CommentEntityManager getCommentEntityManager() {
        return this.getSession(CommentEntityManager.class);
    }

    public PropertyEntityManager getPropertyEntityManager() {
        return this.getSession(PropertyEntityManager.class);
    }

    public EventSubscriptionEntityManager getEventSubscriptionEntityManager() {
        return this.getSession(EventSubscriptionEntityManager.class);
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public HistoryManager getHistoryManager() {
        return this.getSession(HistoryManager.class);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }
}

