/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.HistoricDetailQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.variable.HistoricJPAEntityVariableType;
import org.activiti.engine.impl.variable.JPAEntityVariableType;

public class HistoricDetailQueryImpl
extends AbstractQuery<HistoricDetailQuery, HistoricDetail>
implements HistoricDetailQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String taskId;
    protected String processInstanceId;
    protected String executionId;
    protected String activityId;
    protected String activityInstanceId;
    protected String type;
    protected boolean excludeTaskRelated = false;

    public HistoricDetailQueryImpl() {
    }

    public HistoricDetailQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricDetailQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricDetailQuery id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public HistoricDetailQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public HistoricDetailQuery activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricDetailQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricDetailQuery formProperties() {
        this.type = "FormProperty";
        return this;
    }

    @Override
    public HistoricDetailQuery variableUpdates() {
        this.type = "VariableUpdate";
        return this;
    }

    @Override
    public HistoricDetailQuery excludeTaskDetails() {
        this.excludeTaskRelated = true;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricDetailEntityManager().findHistoricDetailCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricDetail> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        List<HistoricDetail> historicDetails = commandContext.getHistoricDetailEntityManager().findHistoricDetailsByQueryCriteria(this, page);
        HistoricDetailVariableInstanceUpdateEntity varUpdate = null;
        if (historicDetails != null) {
            for (HistoricDetail historicDetail : historicDetails) {
                if (!(historicDetail instanceof HistoricDetailVariableInstanceUpdateEntity)) continue;
                varUpdate = (HistoricDetailVariableInstanceUpdateEntity)historicDetail;
                varUpdate.getBytes();
                if (!(varUpdate.getVariableType() instanceof JPAEntityVariableType)) continue;
                varUpdate.setVariableType(HistoricJPAEntityVariableType.getSharedInstance());
                varUpdate.getValue();
            }
        }
        return historicDetails;
    }

    @Override
    public HistoricDetailQuery orderByProcessInstanceId() {
        this.orderBy(HistoricDetailQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByTime() {
        this.orderBy(HistoricDetailQueryProperty.TIME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableName() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByFormPropertyId() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableRevision() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_REVISION);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableType() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_TYPE);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getType() {
        return this.type;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }
}

