/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.impl.test;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.test.AbstractActivitiTestCase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public abstract class SpringActivitiTestCase
extends AbstractActivitiTestCase
implements ApplicationContextAware {
    protected static Map<String, ProcessEngine> cachedProcessEngines = new HashMap<String, ProcessEngine>();
    protected TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());
    @Autowired
    protected ApplicationContext applicationContext;

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        super.runBare();
    }

    protected void initializeProcessEngine() {
        ContextConfiguration contextConfiguration = ((Object)((Object)this)).getClass().getAnnotation(ContextConfiguration.class);
        String[] value = contextConfiguration.value();
        if (value == null) {
            throw new ActivitiException("value is mandatory in ContextConfiguration");
        }
        if (value.length != 1) {
            throw new ActivitiException("SpringActivitiTestCase requires exactly one value in annotation ContextConfiguration");
        }
        String configurationFile = value[0];
        this.processEngine = cachedProcessEngines.get(configurationFile);
        if (this.processEngine == null) {
            this.processEngine = (ProcessEngine)this.applicationContext.getBean(ProcessEngine.class);
            cachedProcessEngines.put(configurationFile, this.processEngine);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

