/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Collections;
import javax.persistence.Query;
import org.apache.openjpa.datacache.DelegatingQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.QueryResultCache;

public class QueryResultCacheImpl
implements QueryResultCache {
    private final DelegatingQueryCache _cache;

    public QueryResultCacheImpl(QueryCache cache) {
        this._cache = new DelegatingQueryCache(cache, PersistenceExceptions.TRANSLATOR);
    }

    @Override
    public QueryCache getDelegate() {
        return this._cache.getDelegate();
    }

    @Override
    public void pin(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.pin(this.toQueryKey(q));
        }
    }

    @Override
    public void unpin(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.unpin(this.toQueryKey(q));
        }
    }

    @Override
    public void evict(Query q) {
        if (this._cache.getDelegate() != null) {
            this._cache.remove(this.toQueryKey(q));
        }
    }

    @Override
    public void evictAll() {
        this._cache.clear();
    }

    @Override
    public void evictAll(Class cls) {
        this._cache.onTypesChanged(new TypesChangedEvent((Object)this, Collections.singleton(cls)));
    }

    private QueryKey toQueryKey(Query q) {
        QueryImpl impl = (QueryImpl)q;
        if (impl.hasPositionalParameters()) {
            return QueryKey.newInstance((org.apache.openjpa.kernel.Query)impl.getDelegate(), (Object[])impl.getPositionalParameters());
        }
        return QueryKey.newInstance((org.apache.openjpa.kernel.Query)impl.getDelegate(), impl.getNamedParameters());
    }

    public int hashCode() {
        return this._cache == null ? 0 : this._cache.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._cache == null) {
            return false;
        }
        return this._cache.equals((Object)((QueryResultCacheImpl)other)._cache);
    }
}

