/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.search;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.search.AttributableCond;
import org.apache.syncope.common.search.AttributeCond;
import org.apache.syncope.common.search.EntitlementCond;
import org.apache.syncope.common.search.MembershipCond;
import org.apache.syncope.common.search.ResourceCond;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="nodeCondition")
@XmlType
public class NodeCond
extends AbstractBaseBean {
    private static final long serialVersionUID = 661560782247499526L;
    private Type type;
    private AttributableCond attributableCond;
    private AttributeCond attributeCond;
    private MembershipCond membershipCond;
    private ResourceCond resourceCond;
    private EntitlementCond entitlementCond;
    private NodeCond leftNodeCond;
    private NodeCond rightNodeCond;

    public static NodeCond getLeafCond(AttributableCond syncopeUserCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.LEAF;
        nodeCond.attributableCond = syncopeUserCond;
        return nodeCond;
    }

    public static NodeCond getLeafCond(AttributeCond attributeCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.LEAF;
        nodeCond.attributeCond = attributeCond;
        return nodeCond;
    }

    public static NodeCond getLeafCond(MembershipCond membershipCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.LEAF;
        nodeCond.membershipCond = membershipCond;
        return nodeCond;
    }

    public static NodeCond getLeafCond(ResourceCond resourceCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.LEAF;
        nodeCond.resourceCond = resourceCond;
        return nodeCond;
    }

    public static NodeCond getLeafCond(EntitlementCond entitlementCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.LEAF;
        nodeCond.entitlementCond = entitlementCond;
        return nodeCond;
    }

    public static NodeCond getNotLeafCond(AttributableCond syncopeUserCond) {
        NodeCond nodeCond = NodeCond.getLeafCond(syncopeUserCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static NodeCond getNotLeafCond(AttributeCond attributeCond) {
        NodeCond nodeCond = NodeCond.getLeafCond(attributeCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static NodeCond getNotLeafCond(MembershipCond membershipCond) {
        NodeCond nodeCond = NodeCond.getLeafCond(membershipCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static NodeCond getNotLeafCond(ResourceCond resourceCond) {
        NodeCond nodeCond = NodeCond.getLeafCond(resourceCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static NodeCond getNotLeafCond(EntitlementCond entitlementCond) {
        NodeCond nodeCond = NodeCond.getLeafCond(entitlementCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static NodeCond getAndCond(NodeCond leftCond, NodeCond rightCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.AND;
        nodeCond.leftNodeCond = leftCond;
        nodeCond.rightNodeCond = rightCond;
        return nodeCond;
    }

    public static NodeCond getOrCond(NodeCond leftCond, NodeCond rightCond) {
        NodeCond nodeCond = new NodeCond();
        nodeCond.type = Type.OR;
        nodeCond.leftNodeCond = leftCond;
        nodeCond.rightNodeCond = rightCond;
        return nodeCond;
    }

    public AttributableCond getAttributableCond() {
        return this.attributableCond;
    }

    public void setAttributableCond(AttributableCond attributableCond) {
        this.attributableCond = attributableCond;
    }

    public AttributeCond getAttributeCond() {
        return this.attributeCond;
    }

    public void setAttributeCond(AttributeCond attributeCond) {
        this.attributeCond = attributeCond;
    }

    public MembershipCond getMembershipCond() {
        return this.membershipCond;
    }

    public void setMembershipCond(MembershipCond membershipCond) {
        this.membershipCond = membershipCond;
    }

    public ResourceCond getResourceCond() {
        return this.resourceCond;
    }

    public void setResourceCond(ResourceCond resourceCond) {
        this.resourceCond = resourceCond;
    }

    public EntitlementCond getEntitlementCond() {
        return this.entitlementCond;
    }

    public void setEntitlementCond(EntitlementCond entitlementCond) {
        this.entitlementCond = entitlementCond;
    }

    public NodeCond getLeftNodeCond() {
        return this.leftNodeCond;
    }

    public void setLeftNodeCond(NodeCond leftNodeCond) {
        this.leftNodeCond = leftNodeCond;
    }

    public NodeCond getRightNodeCond() {
        return this.rightNodeCond;
    }

    public void setRightNodeCond(NodeCond rightNodeCond) {
        this.rightNodeCond = rightNodeCond;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public boolean isValid() {
        boolean isValid = false;
        if (this.type == null) {
            return isValid;
        }
        switch (this.type) {
            case LEAF: 
            case NOT_LEAF: {
                isValid = !(this.attributableCond == null && this.attributeCond == null && this.membershipCond == null && this.resourceCond == null && this.entitlementCond == null || this.attributableCond != null && !this.attributableCond.isValid() || this.attributeCond != null && !this.attributeCond.isValid() || this.membershipCond != null && !this.membershipCond.isValid() || this.resourceCond != null && !this.resourceCond.isValid() || this.entitlementCond != null && !this.entitlementCond.isValid());
                break;
            }
            case AND: 
            case OR: {
                isValid = this.leftNodeCond == null || this.rightNodeCond == null ? false : this.leftNodeCond.isValid() && this.rightNodeCond.isValid();
                break;
            }
        }
        return isValid;
    }

    @XmlEnum
    @XmlType(name="nodeConditionType")
    public static enum Type {
        LEAF,
        NOT_LEAF,
        AND,
        OR;

    }
}

