/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.xpointer;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.sax.xpointer.ParseException;
import org.apache.cocoon.sax.xpointer.ShorthandPart;
import org.apache.cocoon.sax.xpointer.SimpleCharStream;
import org.apache.cocoon.sax.xpointer.Token;
import org.apache.cocoon.sax.xpointer.UnsupportedPart;
import org.apache.cocoon.sax.xpointer.XPointer;
import org.apache.cocoon.sax.xpointer.XPointerFrameworkParserConstants;
import org.apache.cocoon.sax.xpointer.XPointerFrameworkParserTokenManager;
import org.apache.cocoon.sax.xpointer.XPointerPart;
import org.apache.cocoon.sax.xpointer.XmlnsPart;

public class XPointerFrameworkParser
implements XPointerFrameworkParserConstants {
    private static final String XPOINTER = "xpointer";
    private static final String XMLNS = "xmlns";
    private XPointer xpointer = new XPointer();
    private Map<String, String> namespaces = new HashMap<String, String>();
    public XPointerFrameworkParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static XPointer parse(String xpointer) throws ParseException {
        XPointerFrameworkParser xfp = new XPointerFrameworkParser(new StringReader(xpointer));
        xfp.pointer();
        return xfp.getXPointer();
    }

    public XPointer getXPointer() {
        return this.xpointer;
    }

    private String unescape(String data) throws ParseException {
        StringBuilder result = new StringBuilder(data.length());
        boolean inCircumflex = false;
        block3: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (inCircumflex) {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '^': {
                        result.append(c);
                        inCircumflex = false;
                        continue block3;
                    }
                    default: {
                        throw new ParseException("Incorrect use of circumflex character at position " + i + " in the string " + data);
                    }
                }
            }
            if (c == '^') {
                inCircumflex = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public final void pointer() throws ParseException {
        if (this.jj_2_1(2)) {
            this.schemeBased();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    this.shortHand();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void shortHand() throws ParseException {
        Token x = this.jj_consume_token(7);
        this.xpointer.addPart(new ShorthandPart(x.image));
    }

    public final void schemeBased() throws ParseException {
        this.pointerPart();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(8);
            }
            this.pointerPart();
        }
    }

    public final void pointerPart() throws ParseException {
        Token x;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                x = this.jj_consume_token(7);
                break;
            }
            case 9: {
                x = this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(10);
        this.token_source.SwitchTo(1);
        String schemeName = x.image;
        String schemeData = this.schemeData();
        this.jj_consume_token(11);
        this.token_source.SwitchTo(0);
        String schemeNamespace = null;
        String schemeLocalName = null;
        int colonPos = schemeName.indexOf(58);
        if (colonPos != -1) {
            String schemePrefix = schemeName.substring(0, colonPos);
            schemeNamespace = this.namespaces.get(schemePrefix);
            schemeLocalName = schemeName.substring(colonPos + 1);
        } else {
            schemeLocalName = schemeName;
        }
        if (schemeNamespace == null && XMLNS.equals(schemeLocalName)) {
            int eqPos = schemeData.indexOf("=");
            if (eqPos == -1) {
                throw new ParseException("xmlns scheme data should contain an equals sign");
            }
            String prefix = schemeData.substring(0, eqPos).trim();
            String namespace = schemeData.substring(eqPos + 1, schemeData.length()).trim();
            this.xpointer.addPart(new XmlnsPart(prefix, namespace));
            this.namespaces.put(prefix, namespace);
        } else if (schemeNamespace == null && XPOINTER.equals(schemeLocalName)) {
            this.xpointer.addPart(new XPointerPart(schemeData));
        } else {
            this.xpointer.addPart(new UnsupportedPart(schemeName));
        }
    }

    public final String schemeData() throws ParseException {
        StringBuilder schemeData = new StringBuilder();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            String temp = this.escapedData();
            schemeData.append(temp);
        }
        return this.unescape(schemeData.toString());
    }

    public final String escapedData() throws ParseException {
        StringBuilder data = new StringBuilder();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token x = this.jj_consume_token(15);
                data.append(x.image);
                break;
            }
            case 12: {
                Token x = this.jj_consume_token(12);
                data.append(x.image);
                break;
            }
            case 13: {
                Token x = this.jj_consume_token(13);
                data.append(x.image);
                break;
            }
            case 14: {
                Token x = this.jj_consume_token(14);
                data.append(x.image);
                break;
            }
            case 10: {
                Token x = this.jj_consume_token(10);
                data.append(x.image);
                String temp = this.schemeData();
                data.append(temp);
                x = this.jj_consume_token(11);
                data.append(x.image);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3_1() {
        return this.jj_3R_4();
    }

    private boolean jj_3R_4() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(7)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return this.jj_scan_token(10);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{128, 896, 256, 640, 62464, 62464};
    }

    public XPointerFrameworkParser(InputStream stream) {
        this(stream, null);
    }

    public XPointerFrameworkParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new XPointerFrameworkParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public XPointerFrameworkParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XPointerFrameworkParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public XPointerFrameworkParser(XPointerFrameworkParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(XPointerFrameworkParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[16];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        XPointerFrameworkParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

