/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.head.internal.HeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.IHeaderRenderStrategy;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAjaxResponse {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAjaxResponse.class);
    protected final List<CharSequence> prependJavaScripts = Generics.newArrayList();
    protected final List<CharSequence> appendJavaScripts = Generics.newArrayList();
    protected final List<CharSequence> domReadyJavaScripts = Generics.newArrayList();
    protected final Map<String, Component> markupIdToComponent = new LinkedHashMap<String, Component>();
    protected transient boolean componentsFrozen;
    protected final AjaxResponse encodingBodyResponse;
    protected final AjaxResponse encodingHeaderResponse;
    protected HtmlHeaderContainer header = null;
    private boolean headerRendering = false;
    private IHeaderResponse headerResponse;
    private final Page page;

    public AbstractAjaxResponse(Page page) {
        this.page = page;
        Response response = page.getResponse();
        this.encodingBodyResponse = new AjaxResponse(response);
        this.encodingHeaderResponse = new AjaxResponse(response);
    }

    public void writeTo(Response response, String encoding) {
        this.writeHeader(response, encoding);
        this.fireOnBeforeRespondListeners();
        this.writeComponents(response, encoding);
        this.fireOnAfterRespondListeners(response);
        this.writePriorityEvaluations(response, this.prependJavaScripts);
        ArrayList<CharSequence> evaluationScripts = new ArrayList<CharSequence>();
        evaluationScripts.addAll(this.domReadyJavaScripts);
        evaluationScripts.addAll(this.appendJavaScripts);
        this.writeNormalEvaluations(response, evaluationScripts);
        this.writeFooter(response, encoding);
    }

    protected abstract void fireOnAfterRespondListeners(Response var1);

    protected abstract void fireOnBeforeRespondListeners();

    protected abstract void writeFooter(Response var1, String var2);

    protected abstract void writePriorityEvaluations(Response var1, Collection<CharSequence> var2);

    protected abstract void writeNormalEvaluations(Response var1, Collection<CharSequence> var2);

    private void writeComponents(Response response, String encoding) {
        this.componentsFrozen = true;
        for (Map.Entry<String, Component> stringComponentEntry : this.markupIdToComponent.entrySet()) {
            Component component = stringComponentEntry.getValue();
            if (this.containsAncestorFor(component)) continue;
            this.writeComponent(response, component.getAjaxRegionMarkupId(), component, encoding);
        }
        if (this.header != null) {
            this.headerRendering = true;
            Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
            this.encodingHeaderResponse.reset();
            this.header.getHeaderResponse().close();
            RequestCycle.get().setResponse(oldResponse);
            this.writeHeaderContribution(response);
            this.headerRendering = false;
        }
    }

    protected abstract void writeComponent(Response var1, String var2, Component var3, String var4);

    protected abstract void writeHeader(Response var1, String var2);

    protected abstract void writeHeaderContribution(Response var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAjaxResponse that = (AbstractAjaxResponse)o;
        if (!((Object)this.appendJavaScripts).equals(that.appendJavaScripts)) {
            return false;
        }
        if (!((Object)this.domReadyJavaScripts).equals(that.domReadyJavaScripts)) {
            return false;
        }
        return ((Object)this.prependJavaScripts).equals(that.prependJavaScripts);
    }

    public int hashCode() {
        int result = ((Object)this.prependJavaScripts).hashCode();
        result = 31 * result + ((Object)this.appendJavaScripts).hashCode();
        result = 31 * result + ((Object)this.domReadyJavaScripts).hashCode();
        return result;
    }

    public final void appendJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.appendJavaScripts.add(javascript);
    }

    public final void prependJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.prependJavaScripts.add(javascript);
    }

    public final void add(Component component, String markupId) throws IllegalArgumentException, IllegalStateException {
        Args.notEmpty((CharSequence)markupId, (String)"markupId");
        Args.notNull((Object)component, (String)"component");
        if (component instanceof Page) {
            if (component != this.page) {
                throw new IllegalArgumentException("component cannot be a page");
            }
        } else if (component instanceof AbstractRepeater) {
            throw new IllegalArgumentException("Component " + component.getClass().getName() + " has been added to the target. This component is a repeater and cannot be repainted via ajax directly. " + "Instead add its parent or another markup container higher in the hierarchy.");
        }
        this.assertComponentsNotFrozen();
        component.setMarkupId(markupId);
        this.markupIdToComponent.put(markupId, component);
    }

    public final Collection<? extends Component> getComponents() {
        return Collections.unmodifiableCollection(this.markupIdToComponent.values());
    }

    public void detach(IRequestCycle requestCycle) {
        for (Component component : this.markupIdToComponent.values()) {
            Page parentPage = component.findParent(Page.class);
            if (parentPage == null) continue;
            parentPage.detach();
            break;
        }
    }

    protected boolean containsAncestorFor(Component component) {
        for (MarkupContainer cursor = component.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (!this.markupIdToComponent.containsValue(cursor)) continue;
            return true;
        }
        return false;
    }

    boolean containsPage() {
        return this.markupIdToComponent.values().contains(this.page);
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = new AjaxHeaderResponse();
        }
        return this.headerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeaderContribution(Response response, Component component) {
        this.headerRendering = true;
        if (this.header == null) {
            this.header = new AjaxHtmlHeaderContainer(this);
            Page parentPage = component.getPage();
            parentPage.addOrReplace(this.header);
        }
        RequestCycle requestCycle = component.getRequestCycle();
        Response oldResponse = requestCycle.setResponse(this.encodingHeaderResponse);
        try {
            this.encodingHeaderResponse.reset();
            IHeaderRenderStrategy strategy = AbstractHeaderRenderStrategy.get();
            strategy.renderHeader(this.header, null, component);
        }
        finally {
            requestCycle.setResponse(oldResponse);
        }
        this.writeHeaderContribution(response);
        this.headerRendering = false;
    }

    protected abstract void setContentType(WebResponse var1, String var2);

    static String encode(CharSequence str) {
        if (str == null) {
            return null;
        }
        return ((Object)Strings.replaceAll((CharSequence)str, (CharSequence)"]", (CharSequence)"]^")).toString();
    }

    protected String getEncodingName() {
        return "wicket1";
    }

    static boolean needsEncoding(CharSequence str) {
        return Strings.indexOf((CharSequence)str, (char)']') >= 0;
    }

    private void assertComponentsNotFrozen() {
        this.assertNotFrozen(this.componentsFrozen, Component.class);
    }

    private void assertNotFrozen(boolean frozen, Class<?> clazz) {
        if (frozen) {
            throw new IllegalStateException(Classes.simpleName(clazz) + "s can no " + " longer be added");
        }
    }

    protected static final class AjaxResponse
    extends Response {
        private final AppendingStringBuffer buffer = new AppendingStringBuffer(256);
        private boolean escaped = false;
        private final Response originalResponse;

        private AjaxResponse(Response originalResponse) {
            this.originalResponse = originalResponse;
        }

        public String encodeURL(CharSequence url) {
            return this.originalResponse.encodeURL(url);
        }

        public CharSequence getContents() {
            return this.buffer;
        }

        public boolean isContentsEncoded() {
            return this.escaped;
        }

        public void write(CharSequence cs) {
            String string = ((Object)cs).toString();
            if (AbstractAjaxResponse.needsEncoding(string)) {
                string = AbstractAjaxResponse.encode(string);
                this.escaped = true;
                this.buffer.append(string);
            } else {
                this.buffer.append((Object)cs);
            }
        }

        public void reset() {
            this.buffer.clear();
            this.escaped = false;
        }

        public void write(byte[] array) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public void write(byte[] array, int offset, int length) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public Object getContainerResponse() {
            return this.originalResponse.getContainerResponse();
        }
    }

    private class AjaxHeaderResponse
    extends HeaderResponse {
        private AjaxHeaderResponse() {
        }

        @Override
        public void render(HeaderItem item) {
            if (item instanceof OnLoadHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    AbstractAjaxResponse.this.appendJavaScript(((OnLoadHeaderItem)item).getJavaScript());
                    this.markItemRendered(item);
                }
            } else if (item instanceof OnEventHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    AbstractAjaxResponse.this.appendJavaScript(((OnEventHeaderItem)item).getCompleteJavaScript());
                    this.markItemRendered(item);
                }
            } else if (item instanceof OnDomReadyHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    AbstractAjaxResponse.this.domReadyJavaScripts.add(((OnDomReadyHeaderItem)item).getJavaScript());
                    this.markItemRendered(item);
                }
            } else if (AbstractAjaxResponse.this.headerRendering) {
                super.render(item);
            } else {
                LOG.debug("Only methods that can be called on IHeaderResponse outside renderHead() are #render(OnLoadHeaderItem) and #render(OnDomReadyHeaderItem)");
            }
        }

        @Override
        protected Response getRealResponse() {
            return RequestCycle.get().getResponse();
        }
    }

    private static class AjaxHtmlHeaderContainer
    extends HtmlHeaderContainer {
        private static final long serialVersionUID = 1L;
        private final transient AbstractAjaxResponse ajaxResponse;

        public AjaxHtmlHeaderContainer(AbstractAjaxResponse ajaxResponse) {
            super("_header_");
            this.ajaxResponse = ajaxResponse;
        }

        @Override
        protected IHeaderResponse newHeaderResponse() {
            return this.ajaxResponse.getHeaderResponse();
        }
    }
}

