/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.xpointer;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransformerHandlerFactory {
    private static final SAXTransformerFactory TRAX_FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final String XMLNS_PATTERN = "xmlns:%s=\"%s\"";
    private static final String XSLT_PATTERN = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" %s><xsl:template match=\"%s\"><xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";
    private static final Map<String, Templates> TEMPLATES = new HashMap<String, Templates>();

    private TransformerHandlerFactory() {
    }

    public static TransformerHandler borrowHandler(Map<String, String> namespaces, String expression, ContentHandler delegate) throws TransformerConfigurationException {
        Templates templates = null;
        if (TEMPLATES.containsKey(expression)) {
            templates = TEMPLATES.get(expression);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> namespace : namespaces.entrySet()) {
                builder.append('\n');
                builder.append(String.format(XMLNS_PATTERN, namespace.getKey(), namespace.getValue()));
            }
            String xmlNamespaces = builder.toString();
            String xslt = String.format(XSLT_PATTERN, xmlNamespaces, expression);
            StreamSource source = new StreamSource(new StringReader(xslt));
            templates = TRAX_FACTORY.newTemplates(source);
            TEMPLATES.put(expression, templates);
        }
        SAXResult result = new SAXResult();
        result.setHandler(delegate);
        TransformerHandler transformerHandler = TRAX_FACTORY.newTransformerHandler(templates);
        transformerHandler.setResult(result);
        return transformerHandler;
    }
}

