/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.kernel.FillStrategy;
import org.apache.openjpa.kernel.ResultShape;
import org.apache.openjpa.kernel.exps.AbstractExpressionBuilder;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.TupleFactory;
import org.apache.openjpa.persistence.TupleImpl;
import org.apache.openjpa.persistence.criteria.CompoundSelections;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.OrderImpl;
import org.apache.openjpa.persistence.criteria.PredicateImpl;
import org.apache.openjpa.persistence.criteria.RootImpl;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;
import org.apache.openjpa.persistence.meta.MetamodelImpl;

class CriteriaExpressionBuilder {
    CriteriaExpressionBuilder() {
    }

    public QueryExpressions getQueryExpressions(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        QueryExpressions exps = new QueryExpressions();
        exps.setContexts(q.getContexts());
        this.evalAccessPaths(exps, factory, q);
        exps.alias = null;
        this.evalDistinct(exps, factory, q);
        this.evalFetchJoin(exps, factory, q);
        this.evalCrossJoinRoots(exps, factory, q);
        this.evalFilter(exps, factory, q);
        this.evalGrouping(exps, factory, q);
        this.evalOrderingAndProjection(exps, factory, q);
        exps.operation = 1;
        exps.range = QueryExpressions.EMPTY_VALUES;
        exps.resultClass = q.getResultType();
        exps.shape = this.evalResultShape(q);
        exps.parameterTypes = q.getParameterTypes();
        exps.isAggregate();
        return exps;
    }

    protected void evalAccessPaths(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        HashSet<ClassMetaData> metas = new HashSet<ClassMetaData>();
        MetamodelImpl metamodel = q.getMetamodel();
        for (Root<?> root : q.getRoots()) {
            metas.add(((AbstractManagedType)root.getModel()).meta);
            for (Join join : root.getJoins()) {
                ClassMetaData meta;
                Type.PersistenceType type;
                Class cls = join.getAttribute().getJavaType();
                if (!join.getAttribute().isAssociation() || (type = MetamodelImpl.getPersistenceType(meta = metamodel.getRepository().getMetaData(cls, null, true))) != Type.PersistenceType.ENTITY && type != Type.PersistenceType.EMBEDDABLE) continue;
                metas.add(meta);
            }
            for (Fetch fetch : root.getFetches()) {
                metas.add(metamodel.getRepository().getCachedMetaData(fetch.getAttribute().getJavaType()));
            }
        }
        exps.accessPath = metas.toArray(new ClassMetaData[metas.size()]);
    }

    protected void evalOrderingAndProjection(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        Map<ExpressionImpl<?>, Value> exp2Vals = this.evalOrdering(exps, factory, q);
        this.evalProjections(exps, factory, q, exp2Vals);
    }

    protected Map<ExpressionImpl<?>, Value> evalOrdering(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        List<Order> orders = q.getOrderList();
        MetamodelImpl model = q.getMetamodel();
        int ordercount = orders == null ? 0 : orders.size();
        HashMap exp2Vals = new HashMap();
        exps.ordering = new Value[ordercount];
        exps.orderingClauses = new String[ordercount];
        exps.orderingAliases = new String[ordercount];
        exps.ascending = new boolean[ordercount];
        for (int i = 0; i < ordercount; ++i) {
            String alias;
            Value val;
            OrderImpl order = (OrderImpl)orders.get(i);
            Expression expr = order.getExpression();
            exps.ordering[i] = val = Expressions.toValue(expr, factory, q);
            exps.orderingAliases[i] = alias = expr.getAlias();
            exps.orderingClauses[i] = "";
            val.setAlias(alias);
            exps.ascending[i] = order.isAscending();
            exp2Vals.put((ExpressionImpl<?>)expr, val);
        }
        return exp2Vals;
    }

    protected void evalGrouping(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        List<Expression<?>> groups = q.getGroupList();
        MetamodelImpl model = q.getMetamodel();
        PredicateImpl having = q.getGroupRestriction();
        if (groups == null) {
            return;
        }
        int groupByCount = groups.size();
        exps.grouping = new Value[groupByCount];
        for (int i = 0; i < groupByCount; ++i) {
            Expression<?> groupBy = groups.get(i);
            exps.grouping[i] = Expressions.toValue((ExpressionImpl)groupBy, factory, q);
        }
        exps.having = having == null ? null : having.toKernelExpression(factory, q);
    }

    protected void evalDistinct(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        exps.distinct = q.isDistinct() ? 6 : 8;
    }

    protected void evalCrossJoinRoots(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        Set<Root<?>> roots = q.getRoots();
        SubqueryImpl<?> subQuery = q.getDelegator();
        if (subQuery == null || subQuery.getCorrelatedJoins().isEmpty()) {
            q.assertRoot();
            if (roots.size() > 1) {
                for (Root<?> root : roots) {
                    String alias = q.getAlias((Selection<?>)root);
                    Value var = factory.newBoundVariable(alias, AbstractExpressionBuilder.TYPE_OBJECT);
                    var.setMetaData(((AbstractManagedType)root.getModel()).meta);
                    q.registerRoot(root, var);
                }
            }
        }
    }

    protected void evalFilter(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        Set<Root<?>> roots = q.getRoots();
        MetamodelImpl model = q.getMetamodel();
        PredicateImpl where = q.getRestriction();
        SubqueryImpl<?> subQuery = q.getDelegator();
        org.apache.openjpa.kernel.exps.Expression filter = null;
        if (subQuery == null || subQuery.getCorrelatedJoins().isEmpty()) {
            q.assertRoot();
        }
        for (Root<?> root : roots) {
            for (Join join : root.getJoins()) {
                filter = Expressions.and(factory, ((ExpressionImpl)join).toKernelExpression(factory, q), filter);
            }
            ((RootImpl)root).addToContext(factory, model, q);
        }
        if (subQuery != null) {
            Set<Join<?, ?>> corrJoins = subQuery.getCorrelatedJoins();
            for (Join<?, ?> corrJoin : corrJoins) {
                filter = Expressions.and(factory, ((ExpressionImpl)corrJoin).toKernelExpression(factory, q), filter);
            }
        }
        if (where != null) {
            filter = Expressions.and(factory, where.toKernelExpression(factory, q), filter);
        }
        if (filter == null) {
            filter = factory.emptyExpression();
        }
        exps.filter = filter;
    }

    protected void evalProjections(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q, Map<ExpressionImpl<?>, Value> exp2Vals) {
        List<Selection<?>> selections = q.getSelectionList();
        MetamodelImpl model = q.getMetamodel();
        if (q.isDefaultProjection()) {
            exps.projections = new Value[0];
            return;
        }
        exps.projections = new Value[selections.size()];
        ArrayList<Value> projections = new ArrayList<Value>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> clauses = new ArrayList<String>();
        this.getProjections(exps, selections, projections, aliases, clauses, factory, q, model, exp2Vals);
        exps.projections = projections.toArray(new Value[projections.size()]);
        exps.projectionAliases = aliases.toArray(new String[aliases.size()]);
        exps.projectionClauses = clauses.toArray(new String[clauses.size()]);
    }

    private void getProjections(QueryExpressions exps, List<Selection<?>> selections, List<Value> projections, List<String> aliases, List<String> clauses, ExpressionFactory factory, CriteriaQueryImpl<?> q, MetamodelImpl model, Map<ExpressionImpl<?>, Value> exp2Vals) {
        if (selections.size() == 0 && q.getDelegator() != null) {
            Root<?> r = q.getRoot();
            selections = new ArrayList(1);
            selections.add((Selection<?>)r);
        }
        for (Selection<?> s : selections) {
            if (s.isCompoundSelection()) {
                this.getProjections(exps, s.getCompoundSelectionItems(), projections, aliases, clauses, factory, q, model, exp2Vals);
                continue;
            }
            Value val = exp2Vals != null && exp2Vals.containsKey(s) ? exp2Vals.get(s) : ((ExpressionImpl)s).toValue(factory, q);
            String alias = s.getAlias();
            val.setAlias(alias);
            projections.add(val);
            aliases.add(alias);
            clauses.add(alias);
        }
    }

    protected void evalFetchJoin(QueryExpressions exps, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        ArrayList<String> iPaths = new ArrayList<String>();
        ArrayList<String> oPaths = new ArrayList<String>();
        Set<Root<?>> roots = q.getRoots();
        for (Root<?> root : roots) {
            Set fetches = root.getFetches();
            if (fetches == null) continue;
            for (Fetch fetch : fetches) {
                String fPath = ((Members.Member)fetch.getAttribute()).fmd.getFullName(false);
                oPaths.add(fPath);
                if (fetch.getJoinType() != JoinType.INNER) continue;
                iPaths.add(fPath);
            }
        }
        if (!iPaths.isEmpty()) {
            exps.fetchInnerPaths = iPaths.toArray(new String[iPaths.size()]);
        }
        if (!oPaths.isEmpty()) {
            exps.fetchPaths = oPaths.toArray(new String[oPaths.size()]);
        }
    }

    ResultShape<?> getShape(CriteriaQueryImpl<?> q, ResultShape<?> parent, Selection<?> s) {
        ResultShape<Object> result = null;
        Class<Object> type = s.getJavaType();
        if (type == null) {
            type = Object.class;
        }
        if (s.isCompoundSelection()) {
            CompoundSelection cs = (CompoundSelection)s;
            result = new ResultShape(s.getJavaType(), CompoundSelections.getFillStrategy(cs));
            List terms = cs.getCompoundSelectionItems();
            for (Selection term : terms) {
                result.nest(this.getShape(q, result, term));
            }
        } else {
            Class<?> componentType;
            result = parent.getType().isArray() && q.isMultiselect() ? ((componentType = parent.getType().getComponentType()) == Tuple.class ? new ResultShape<Tuple>(componentType, new FillStrategy.Factory<Tuple>(new TupleFactory(s), TupleImpl.PUT), false) : new ResultShape(componentType, new FillStrategy.Assign(), true)) : new ResultShape<Object>(type, new FillStrategy.Assign(), true);
        }
        return result;
    }

    private ResultShape<?> evalResultShape(CriteriaQueryImpl<?> q) {
        List<Selection<?>> selections = q.getSelectionList();
        Class<?> resultClass = q.getResultType();
        ResultShape result = null;
        if (q.isMultiselect()) {
            result = new ResultShape(resultClass, CompoundSelections.getFillStrategy(q.getSelection()));
            for (Selection<?> term : selections) {
                result.nest(this.getShape(q, result, term));
            }
        } else {
            FillStrategy<Object> strategy = new FillStrategy.Assign();
            if (Tuple.class.isAssignableFrom(resultClass)) {
                TupleFactory factory = new TupleFactory(selections.toArray(new TupleElement[selections.size()]));
                strategy = new FillStrategy.Factory<Tuple>(factory, TupleImpl.PUT);
            }
            result = new ResultShape(resultClass, strategy);
            if (q.getSelectionList() == null) {
                return result;
            }
            if (q.getSelectionList().size() == 1) {
                result = this.getShape(q, result, q.getSelectionList().get(0));
            } else {
                for (Selection<?> term : q.getSelectionList()) {
                    result.nest(this.getShape(q, result, term));
                }
            }
        }
        return result;
    }
}

