/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.BitSet;
import org.apache.openjpa.audit.AuditableOperation;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;

public final class Audited {
    private final StateManagerImpl _sm;
    private final PersistenceCapable _original;

    Audited(StateManagerImpl sm, PersistenceCapable o) {
        if (sm == null || o == null) {
            throw new NullPointerException("sm: " + sm + " original: " + o);
        }
        if (o.pcGetStateManager() != null) {
            throw new IllegalArgumentException(o + " is not transient");
        }
        this._sm = sm;
        this._original = o;
    }

    public Object getManagedObject() {
        return this._sm.getManagedInstance();
    }

    public Object getOriginalObject() {
        return this._original;
    }

    public String[] getUpdatedFields() {
        BitSet dirty = this._sm.getDirty();
        String[] names = new String[dirty.cardinality()];
        int j = 0;
        for (int i = 0; i < dirty.size(); ++i) {
            if (!dirty.get(i)) continue;
            names[j++] = this._sm.getMetaData().getField(i).getName();
        }
        return names;
    }

    public AuditableOperation getType() {
        PCState state = this._sm.getPCState();
        if (state.isNew()) {
            return AuditableOperation.CREATE;
        }
        if (state.isDeleted()) {
            return AuditableOperation.DELETE;
        }
        if (state.isDirty()) {
            return AuditableOperation.UPDATE;
        }
        return null;
    }
}

