/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.render;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPageRenderer
extends PageRenderer {
    private static final Logger logger = LoggerFactory.getLogger(WebPageRenderer.class);

    public WebPageRenderer(RenderPageRequestHandler renderPageRequestHandler) {
        super(renderPageRequestHandler);
    }

    private boolean isAjax(RequestCycle requestCycle) {
        boolean isAjax = false;
        Request request = requestCycle.getRequest();
        if (request instanceof WebRequest) {
            WebRequest webRequest = (WebRequest)request;
            isAjax = webRequest.isAjax();
        }
        return isAjax;
    }

    protected void storeBufferedResponse(Url url, BufferedWebResponse response) {
        WebApplication.get().storeBufferedResponse(this.getSessionId(), url, response);
    }

    protected BufferedWebResponse getAndRemoveBufferedResponse(Url url) {
        return WebApplication.get().getAndRemoveBufferedResponse(this.getSessionId(), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedWebResponse renderPage(Url targetUrl, RequestCycle requestCycle) {
        IRequestablePage requestablePage = this.getPage();
        IRequestHandler scheduled = requestCycle.getRequestHandlerScheduledAfterCurrent();
        if (scheduled != null) {
            return null;
        }
        WebResponse originalResponse = (WebResponse)requestCycle.getResponse();
        BufferedWebResponse response = new BufferedWebResponse(originalResponse);
        Url originalBaseUrl = requestCycle.getUrlRenderer().setBaseUrl(targetUrl);
        try {
            requestCycle.setResponse((Response)response);
            requestablePage.renderPage();
            if (scheduled == null && requestCycle.getRequestHandlerScheduledAfterCurrent() != null) {
                originalResponse.reset();
                response.writeMetaData(originalResponse);
                BufferedWebResponse bufferedWebResponse = null;
                return bufferedWebResponse;
            }
            BufferedWebResponse bufferedWebResponse = response;
            return bufferedWebResponse;
        }
        finally {
            requestCycle.setResponse((Response)originalResponse);
            requestCycle.getUrlRenderer().setBaseUrl(originalBaseUrl);
        }
    }

    protected void redirectTo(Url url, RequestCycle requestCycle) {
        this.bindSessionIfNeeded();
        WebResponse response = (WebResponse)requestCycle.getResponse();
        String relativeUrl = requestCycle.getUrlRenderer().renderUrl(url);
        response.sendRedirect(relativeUrl);
    }

    private void bindSessionIfNeeded() {
        FeedbackCollector collector = new FeedbackCollector();
        List<FeedbackMessage> feedbackMessages = collector.collect();
        if (feedbackMessages.size() > 0) {
            Session.get().bind();
        }
    }

    @Override
    public void respond(RequestCycle requestCycle) {
        Url currentUrl = requestCycle.getUrlRenderer().getBaseUrl();
        Url targetUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
        BufferedWebResponse bufferedResponse = this.getAndRemoveBufferedResponse(currentUrl);
        boolean isAjax = this.isAjax(requestCycle);
        boolean shouldPreserveClientUrl = ((WebRequest)requestCycle.getRequest()).shouldPreserveClientUrl();
        if (bufferedResponse != null) {
            logger.warn("The Buffered response should be handled by BufferedResponseRequestHandler");
            bufferedResponse.writeTo((WebResponse)requestCycle.getResponse());
        } else if (this.getRedirectPolicy() == RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT || this.isOnePassRender() && !isAjax && this.getRedirectPolicy() != RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT || !isAjax && targetUrl.equals((Object)currentUrl) && !this.getPageProvider().isNewPageInstance() && !this.getPage().isPageStateless() || targetUrl.equals((Object)currentUrl) && this.isRedirectToRender() || shouldPreserveClientUrl) {
            BufferedWebResponse response = this.renderPage(currentUrl, requestCycle);
            if (response != null) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            }
        } else if (this.getRedirectPolicy() == RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT || this.isRedirectToRender() || isAjax && targetUrl.equals((Object)currentUrl)) {
            this.redirectTo(targetUrl, requestCycle);
        } else if (!targetUrl.equals((Object)currentUrl) && (this.getPageProvider().isNewPageInstance() || this.isSessionTemporary() && this.getPage().isPageStateless())) {
            this.redirectTo(targetUrl, requestCycle);
        } else {
            if (!this.isRedirectToBuffer() && logger.isDebugEnabled()) {
                String details = String.format("redirect strategy: '%s', isAjax: '%s', redirect policy: '%s', current url: '%s', target url: '%s', is new: '%s', is stateless: '%s', is temporary: '%s'", new Object[]{Application.get().getRequestCycleSettings().getRenderStrategy(), isAjax, this.getRedirectPolicy(), currentUrl, targetUrl, this.getPageProvider().isNewPageInstance(), this.getPage().isPageStateless(), this.isSessionTemporary()});
                logger.debug("Falling back to Redirect_To_Buffer render strategy because none of the conditions matched. Details: " + details);
            }
            this.getPage();
            Url renderTargetUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
            BufferedWebResponse response = this.renderPage(renderTargetUrl, requestCycle);
            if (response == null) {
                return;
            }
            if (currentUrl.equals((Object)renderTargetUrl)) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else if (this.getPage().isPageStateless() && !this.enableRedirectForStatelessPage()) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else {
                this.storeBufferedResponse(renderTargetUrl, response);
                this.redirectTo(renderTargetUrl, requestCycle);
            }
        }
    }
}

