/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.lang.StringUtils;

public class FormPropertyParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "formProperty";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof UserTask) && !(parentElement instanceof StartEvent)) {
            return;
        }
        FormProperty property = new FormProperty();
        BpmnXMLUtil.addXMLLocation((BaseElement)property, xtr);
        property.setId(xtr.getAttributeValue(null, "id"));
        property.setName(xtr.getAttributeValue(null, "name"));
        property.setType(xtr.getAttributeValue(null, "type"));
        property.setVariable(xtr.getAttributeValue(null, "variable"));
        property.setExpression(xtr.getAttributeValue(null, "expression"));
        property.setDefaultExpression(xtr.getAttributeValue(null, "default"));
        property.setDatePattern(xtr.getAttributeValue(null, "datePattern"));
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "required"))) {
            property.setRequired(Boolean.valueOf(xtr.getAttributeValue(null, "required")).booleanValue());
        }
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "readable"))) {
            property.setReadable(Boolean.valueOf(xtr.getAttributeValue(null, "readable")).booleanValue());
        }
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "writable"))) {
            property.setWriteable(Boolean.valueOf(xtr.getAttributeValue(null, "writable")).booleanValue());
        }
        boolean readyWithFormProperty = false;
        try {
            while (!readyWithFormProperty && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "value".equalsIgnoreCase(xtr.getLocalName())) {
                    FormValue value = new FormValue();
                    BpmnXMLUtil.addXMLLocation((BaseElement)value, xtr);
                    value.setId(xtr.getAttributeValue(null, "id"));
                    value.setName(xtr.getAttributeValue(null, "name"));
                    property.getFormValues().add(value);
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithFormProperty = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing form properties child elements", (Throwable)e);
        }
        if (parentElement instanceof UserTask) {
            ((UserTask)parentElement).getFormProperties().add(property);
        } else {
            ((StartEvent)parentElement).getFormProperties().add(property);
        }
    }
}

