/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.util.Set;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache
implements Cache {
    @Override
    public final CacheValue get(CacheKey cacheKey) {
        return this.get(cacheKey, false);
    }

    @Override
    public final CacheValue get(CacheKey cacheKey, boolean includeInvalid) {
        CacheValue cacheValue = this.retrieve(cacheKey);
        if (includeInvalid || this.isValid(cacheKey, cacheValue)) {
            return cacheValue;
        }
        return null;
    }

    @Override
    public final void put(CacheKey cacheKey, CacheValue cacheValue) {
        this.store(cacheKey, cacheValue);
    }

    @Override
    public void clear() {
        this.doClear();
    }

    @Override
    public boolean remove(CacheKey cacheKey) {
        return this.doRemove(cacheKey);
    }

    @Override
    public Set<CacheKey> keySet() {
        return this.retrieveKeySet();
    }

    protected boolean isValid(CacheKey cacheKey, CacheValue cacheValue) {
        if (cacheValue == null) {
            return false;
        }
        return cacheValue.isValid(cacheKey);
    }

    protected abstract CacheValue retrieve(CacheKey var1);

    protected abstract void store(CacheKey var1, CacheValue var2);

    protected abstract void doClear();

    protected abstract boolean doRemove(CacheKey var1);

    protected abstract Set<CacheKey> retrieveKeySet();
}

