/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.lang.reflect.Field;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class ClientProperties
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private int browserHeight = -1;
    private boolean browserInternetExplorer;
    private boolean browserKonqueror;
    private boolean browserMozilla;
    private boolean browserMozillaFirefox;
    private boolean browserOpera;
    private boolean browserSafari;
    private boolean browserChrome;
    private int browserVersionMajor = -1;
    private int browserVersionMinor = -1;
    private int browserWidth = -1;
    private boolean cookiesEnabled;
    private boolean javaEnabled;
    private String navigatorAppCodeName;
    private String navigatorAppName;
    private String navigatorAppVersion;
    private String navigatorLanguage;
    private String navigatorPlatform;
    private String navigatorUserAgent;
    private boolean proprietaryIECssExpressionsSupported;
    private boolean proprietaryIEPngAlphaFilterRequired;
    private boolean quirkCssBackgroundAttachmentUseFixed;
    private boolean quirkCssBorderCollapseFor0Padding;
    private boolean quirkCssBorderCollapseInside;
    private boolean quirkCssPositioningOneSideOnly;
    private boolean quirkIERepaint;
    private boolean quirkIESelectListDomUpdate;
    private boolean quirkIESelectPercentWidth;
    private boolean quirkIESelectZIndex;
    private boolean quirkIETablePercentWidthScrollbarError;
    private boolean quirkIETextareaNewlineObliteration;
    private boolean quirkMozillaPerformanceLargeDomRemove;
    private boolean quirkMozillaTextInputRepaint;
    private String remoteAddress;
    private int screenColorDepth = -1;
    private int screenHeight = -1;
    private int screenWidth = -1;
    private TimeZone timeZone;
    private String utcDSTOffset;
    private String utcOffset;
    private String hostname;

    public int getBrowserHeight() {
        return this.browserHeight;
    }

    public int getBrowserVersionMajor() {
        return this.browserVersionMajor;
    }

    public int getBrowserVersionMinor() {
        return this.browserVersionMinor;
    }

    public int getBrowserWidth() {
        return this.browserWidth;
    }

    public String getNavigatorAppCodeName() {
        return this.navigatorAppCodeName;
    }

    public String getNavigatorAppName() {
        return this.navigatorAppName;
    }

    public String getNavigatorAppVersion() {
        return this.navigatorAppVersion;
    }

    public String getNavigatorLanguage() {
        return this.navigatorLanguage;
    }

    public String getNavigatorPlatform() {
        return this.navigatorPlatform;
    }

    public String getNavigatorUserAgent() {
        return this.navigatorUserAgent;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getScreenColorDepth() {
        return this.screenColorDepth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public TimeZone getTimeZone() {
        String utc;
        if (this.timeZone == null && (utc = this.getUtcOffset()) != null) {
            int dotPos = utc.indexOf(46);
            if (dotPos >= 0) {
                String hours = utc.substring(0, dotPos);
                String hourPart = utc.substring(dotPos + 1);
                if (hours.startsWith("+")) {
                    hours = hours.substring(1);
                }
                int offsetHours = Integer.parseInt(hours);
                int offsetMins = (int)(Double.parseDouble(hourPart) * 6.0);
                AppendingStringBuffer sb = new AppendingStringBuffer((CharSequence)"GMT");
                sb.append(offsetHours > 0 ? "+" : "-");
                sb.append(Math.abs(offsetHours));
                sb.append(":");
                if (offsetMins < 10) {
                    sb.append("0");
                }
                sb.append(offsetMins);
                this.timeZone = TimeZone.getTimeZone(sb.toString());
            } else {
                int offset = Integer.parseInt(utc);
                if (offset < 0) {
                    utc = utc.substring(1);
                }
                this.timeZone = TimeZone.getTimeZone("GMT" + (offset > 0 ? "+" : "-") + utc);
            }
            String dstOffset = this.getUtcDSTOffset();
            if (this.timeZone != null && dstOffset != null) {
                TimeZone dstTimeZone = null;
                dotPos = dstOffset.indexOf(46);
                if (dotPos >= 0) {
                    String hours = dstOffset.substring(0, dotPos);
                    String hourPart = dstOffset.substring(dotPos + 1);
                    if (hours.startsWith("+")) {
                        hours = hours.substring(1);
                    }
                    int offsetHours = Integer.parseInt(hours);
                    int offsetMins = (int)(Double.parseDouble(hourPart) * 6.0);
                    AppendingStringBuffer sb = new AppendingStringBuffer((CharSequence)"GMT");
                    sb.append(offsetHours > 0 ? "+" : "-");
                    sb.append(Math.abs(offsetHours));
                    sb.append(":");
                    if (offsetMins < 10) {
                        sb.append("0");
                    }
                    sb.append(offsetMins);
                    dstTimeZone = TimeZone.getTimeZone(sb.toString());
                } else {
                    int offset = Integer.parseInt(dstOffset);
                    if (offset < 0) {
                        dstOffset = dstOffset.substring(1);
                    }
                    dstTimeZone = TimeZone.getTimeZone("GMT" + (offset > 0 ? "+" : "-") + dstOffset);
                }
                if (dstTimeZone != null && dstTimeZone.getRawOffset() != this.timeZone.getRawOffset()) {
                    String[] availableIDs;
                    int dstSaving = dstTimeZone.getRawOffset() - this.timeZone.getRawOffset();
                    for (String availableID : availableIDs = TimeZone.getAvailableIDs(this.timeZone.getRawOffset())) {
                        TimeZone zone = TimeZone.getTimeZone(availableID);
                        if (zone.getDSTSavings() != dstSaving) continue;
                        this.timeZone = zone;
                        break;
                    }
                }
            }
        }
        return this.timeZone;
    }

    public String getUtcDSTOffset() {
        return this.utcDSTOffset;
    }

    public String getUtcOffset() {
        return this.utcOffset;
    }

    public boolean isBrowserInternetExplorer() {
        return this.browserInternetExplorer;
    }

    public boolean isBrowserKonqueror() {
        return this.browserKonqueror;
    }

    public boolean isBrowserMozilla() {
        return this.browserMozilla;
    }

    public boolean isBrowserMozillaFirefox() {
        return this.browserMozillaFirefox;
    }

    public boolean isBrowserOpera() {
        return this.browserOpera;
    }

    public boolean isBrowserSafari() {
        return this.browserSafari;
    }

    public boolean isBrowserChrome() {
        return this.browserChrome;
    }

    public boolean isCookiesEnabled() {
        if (!this.cookiesEnabled && RequestCycle.get() != null) {
            List cookies = ((WebRequest)RequestCycle.get().getRequest()).getCookies();
            this.cookiesEnabled = cookies != null && cookies.size() > 0;
        }
        return this.cookiesEnabled;
    }

    public boolean isJavaEnabled() {
        return this.javaEnabled;
    }

    public boolean isProprietaryIECssExpressionsSupported() {
        return this.proprietaryIECssExpressionsSupported;
    }

    public boolean isProprietaryIEPngAlphaFilterRequired() {
        return this.proprietaryIEPngAlphaFilterRequired;
    }

    public boolean isQuirkCssBackgroundAttachmentUseFixed() {
        return this.quirkCssBackgroundAttachmentUseFixed;
    }

    public boolean isQuirkCssBorderCollapseFor0Padding() {
        return this.quirkCssBorderCollapseFor0Padding;
    }

    public boolean isQuirkCssBorderCollapseInside() {
        return this.quirkCssBorderCollapseInside;
    }

    public boolean isQuirkCssPositioningOneSideOnly() {
        return this.quirkCssPositioningOneSideOnly;
    }

    public boolean isQuirkIERepaint() {
        return this.quirkIERepaint;
    }

    public boolean isQuirkIESelectListDomUpdate() {
        return this.quirkIESelectListDomUpdate;
    }

    public boolean isQuirkIESelectPercentWidth() {
        return this.quirkIESelectPercentWidth;
    }

    public boolean isQuirkIESelectZIndex() {
        return this.quirkIESelectZIndex;
    }

    public boolean isQuirkIETablePercentWidthScrollbarError() {
        return this.quirkIETablePercentWidthScrollbarError;
    }

    public boolean isQuirkIETextareaNewlineObliteration() {
        return this.quirkIETextareaNewlineObliteration;
    }

    public boolean isQuirkMozillaPerformanceLargeDomRemove() {
        return this.quirkMozillaPerformanceLargeDomRemove;
    }

    public boolean isQuirkMozillaTextInputRepaint() {
        return this.quirkMozillaTextInputRepaint;
    }

    public void setBrowserHeight(int browserHeight) {
        this.browserHeight = browserHeight;
    }

    public void setBrowserInternetExplorer(boolean browserInternetExplorer) {
        this.browserInternetExplorer = browserInternetExplorer;
    }

    public void setBrowserKonqueror(boolean browserKonqueror) {
        this.browserKonqueror = browserKonqueror;
    }

    public void setBrowserMozilla(boolean browserMozilla) {
        this.browserMozilla = browserMozilla;
    }

    public void setBrowserMozillaFirefox(boolean browserMozillaFirefox) {
        this.browserMozillaFirefox = browserMozillaFirefox;
    }

    public void setBrowserOpera(boolean browserOpera) {
        this.browserOpera = browserOpera;
    }

    public void setBrowserSafari(boolean browserSafari) {
        this.browserSafari = browserSafari;
    }

    public void setBrowserChrome(boolean browserChrome) {
        this.browserChrome = browserChrome;
    }

    public void setBrowserVersionMajor(int browserVersionMajor) {
        this.browserVersionMajor = browserVersionMajor;
    }

    public void setBrowserVersionMinor(int browserVersionMinor) {
        this.browserVersionMinor = browserVersionMinor;
    }

    public void setBrowserWidth(int browserWidth) {
        this.browserWidth = browserWidth;
    }

    public void setCookiesEnabled(boolean cookiesEnabled) {
        this.cookiesEnabled = cookiesEnabled;
    }

    public void setJavaEnabled(boolean navigatorJavaEnabled) {
        this.javaEnabled = navigatorJavaEnabled;
    }

    public void setNavigatorAppCodeName(String navigatorAppCodeName) {
        this.navigatorAppCodeName = navigatorAppCodeName;
    }

    public void setNavigatorAppName(String navigatorAppName) {
        this.navigatorAppName = navigatorAppName;
    }

    public void setNavigatorAppVersion(String navigatorAppVersion) {
        this.navigatorAppVersion = navigatorAppVersion;
    }

    public void setNavigatorLanguage(String navigatorLanguage) {
        this.navigatorLanguage = navigatorLanguage;
    }

    public void setNavigatorPlatform(String navigatorPlatform) {
        this.navigatorPlatform = navigatorPlatform;
    }

    public void setNavigatorUserAgent(String navigatorUserAgent) {
        this.navigatorUserAgent = navigatorUserAgent;
    }

    public void setProprietaryIECssExpressionsSupported(boolean proprietaryIECssExpressionsSupported) {
        this.proprietaryIECssExpressionsSupported = proprietaryIECssExpressionsSupported;
    }

    public void setProprietaryIEPngAlphaFilterRequired(boolean proprietaryIEPngAlphaFilterRequired) {
        this.proprietaryIEPngAlphaFilterRequired = proprietaryIEPngAlphaFilterRequired;
    }

    public void setQuirkCssBackgroundAttachmentUseFixed(boolean quirkCssBackgroundAttachmentUseFixed) {
        this.quirkCssBackgroundAttachmentUseFixed = quirkCssBackgroundAttachmentUseFixed;
    }

    public void setQuirkCssBorderCollapseFor0Padding(boolean quirkCssBorderCollapseFor0Padding) {
        this.quirkCssBorderCollapseFor0Padding = quirkCssBorderCollapseFor0Padding;
    }

    public void setQuirkCssBorderCollapseInside(boolean quirkCssBorderCollapseInside) {
        this.quirkCssBorderCollapseInside = quirkCssBorderCollapseInside;
    }

    public void setQuirkCssPositioningOneSideOnly(boolean quirkCssPositioningOneSideOnly) {
        this.quirkCssPositioningOneSideOnly = quirkCssPositioningOneSideOnly;
    }

    public void setQuirkIERepaint(boolean quirkIERepaint) {
        this.quirkIERepaint = quirkIERepaint;
    }

    public void setQuirkIESelectListDomUpdate(boolean quirkIESelectListDomUpdate) {
        this.quirkIESelectListDomUpdate = quirkIESelectListDomUpdate;
    }

    public void setQuirkIESelectPercentWidth(boolean quirkIESelectPercentWidth) {
        this.quirkIESelectPercentWidth = quirkIESelectPercentWidth;
    }

    public void setQuirkIESelectZIndex(boolean quirkIESelectZIndex) {
        this.quirkIESelectZIndex = quirkIESelectZIndex;
    }

    public void setQuirkIETablePercentWidthScrollbarError(boolean quirkIETablePercentWidthScrollbarError) {
        this.quirkIETablePercentWidthScrollbarError = quirkIETablePercentWidthScrollbarError;
    }

    public void setQuirkIETextareaNewlineObliteration(boolean quirkIETextareaNewlineObliteration) {
        this.quirkIETextareaNewlineObliteration = quirkIETextareaNewlineObliteration;
    }

    public void setQuirkMozillaPerformanceLargeDomRemove(boolean quirkMozillaPerformanceLargeDomRemove) {
        this.quirkMozillaPerformanceLargeDomRemove = quirkMozillaPerformanceLargeDomRemove;
    }

    public void setQuirkMozillaTextInputRepaint(boolean quirkMozillaTextInputRepaint) {
        this.quirkMozillaTextInputRepaint = quirkMozillaTextInputRepaint;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setScreenColorDepth(int screenColorDepth) {
        this.screenColorDepth = screenColorDepth;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setUtcDSTOffset(String utcDSTOffset) {
        this.utcDSTOffset = utcDSTOffset;
    }

    public void setUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
    }

    public String toString() {
        Field[] fields;
        StringBuilder b = new StringBuilder();
        for (Field field : fields = ClientProperties.class.getDeclaredFields()) {
            if (field.getName().equals("serialVersionUID") || field.getName().startsWith("class$") || field.getName().startsWith("timeZone")) continue;
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(this);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (field.getType().equals(Integer.TYPE) && (Integer)value == -1) {
                value = null;
            }
            if (value == null) continue;
            b.append(field.getName());
            b.append("=");
            b.append(value);
            b.append("\n");
        }
        return b.toString();
    }
}

