/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.validation;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.util.lang.Objects;

public class EqualInputValidator
extends AbstractFormValidator {
    private static final long serialVersionUID = 1L;
    private final FormComponent<?>[] components;

    public EqualInputValidator(FormComponent<?> formComponent1, FormComponent<?> formComponent2) {
        if (formComponent1 == null) {
            throw new IllegalArgumentException("argument formComponent1 cannot be null");
        }
        if (formComponent2 == null) {
            throw new IllegalArgumentException("argument formComponent2 cannot be null");
        }
        this.components = new FormComponent[]{formComponent1, formComponent2};
    }

    @Override
    public FormComponent<?>[] getDependentFormComponents() {
        return this.components;
    }

    @Override
    public void validate(Form<?> form) {
        FormComponent<?> formComponent1 = this.components[0];
        FormComponent<?> formComponent2 = this.components[1];
        if (!Objects.equal((Object)formComponent1.getInput(), (Object)formComponent2.getInput())) {
            this.error(formComponent2);
        }
    }
}

