/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.xpointer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.sax.xpointer.PointerPart;
import org.apache.cocoon.sax.xpointer.XPointerContext;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class XPointer
implements ContentHandler {
    private final List<PointerPart> pointerParts = new ArrayList<PointerPart>();
    private Log log;

    public void setLog(Log log) {
        this.log = log;
    }

    public void addPart(PointerPart part) {
        this.pointerParts.add(part);
    }

    public void setUp(XPointerContext xpointerContext) throws SAXException, IOException {
        for (PointerPart pointerPart : this.pointerParts) {
            pointerPart.setUp(xpointerContext);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.characters(ch, start, length);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading characters", (Throwable)e);
            }
        }
    }

    public void endDocument() throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.endDocument();
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading endDocument", (Throwable)e);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.endElement(uri, localName, qName);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading endElement", (Throwable)e);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.endPrefixMapping(prefix);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading endPrefixMapping", (Throwable)e);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.ignorableWhitespace(ch, start, length);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading ignorableWhitespace", (Throwable)e);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.processingInstruction(target, data);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading processingInstruction", (Throwable)e);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        for (PointerPart contentHandler : this.pointerParts) {
            contentHandler.setDocumentLocator(locator);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.skippedEntity(name);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading skippedEntity", (Throwable)e);
            }
        }
    }

    public void startDocument() throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.startDocument();
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading skippedEntity", (Throwable)e);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.startElement(uri, localName, qName, atts);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading skippedEntity", (Throwable)e);
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (PointerPart contentHandler : this.pointerParts) {
            try {
                contentHandler.startPrefixMapping(prefix, uri);
            }
            catch (SAXException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"An error occurred while spreading skippedEntity", (Throwable)e);
            }
        }
    }
}

