/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.List;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;

public class ModelEntityManager
extends AbstractManager {
    public Model createNewModel() {
        return new ModelEntity();
    }

    public void insertModel(Model model) {
        ((ModelEntity)model).setCreateTime(new Date());
        this.getDbSqlSession().insert((PersistentObject)((Object)model));
    }

    public void updateModel(ModelEntity updatedModel) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(updatedModel);
    }

    public void deleteModel(String modelId) {
        ModelEntity model = this.getDbSqlSession().selectById(ModelEntity.class, modelId);
        this.getDbSqlSession().delete(model);
        this.deleteEditorSource(model);
        this.deleteEditorSourceExtra(model);
    }

    public void insertEditorSourceForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findModelById(modelId);
        if (model != null) {
            ByteArrayEntity byteArrayValue = null;
            if (model.getEditorSourceValueId() != null) {
                Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(model.getEditorSourceValueId());
            }
            if (modelSource != null) {
                byteArrayValue = new ByteArrayEntity(modelSource);
                Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
            }
            if (byteArrayValue != null) {
                model.setEditorSourceValueId(byteArrayValue.getId());
                this.updateModel(model);
            }
        }
    }

    public void deleteEditorSource(ModelEntity model) {
        if (model.getEditorSourceValueId() != null) {
            ByteArrayEntity data = this.getDbSqlSession().selectById(ByteArrayEntity.class, model.getEditorSourceValueId());
            this.getDbSqlSession().delete(data);
        }
    }

    public void deleteEditorSourceExtra(ModelEntity model) {
        if (model.getEditorSourceExtraValueId() != null) {
            ByteArrayEntity data = this.getDbSqlSession().selectById(ByteArrayEntity.class, model.getEditorSourceExtraValueId());
            this.getDbSqlSession().delete(data);
        }
    }

    public void insertEditorSourceExtraForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findModelById(modelId);
        if (model != null) {
            ByteArrayEntity byteArrayValue = null;
            if (model.getEditorSourceExtraValueId() != null) {
                Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(model.getEditorSourceExtraValueId());
            }
            if (modelSource != null) {
                byteArrayValue = new ByteArrayEntity(modelSource);
                Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
            }
            if (byteArrayValue != null) {
                model.setEditorSourceExtraValueId(byteArrayValue.getId());
                this.updateModel(model);
            }
        }
    }

    public ModelQuery createNewModelQuery() {
        return new ModelQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public List<Model> findModelsByQueryCriteria(ModelQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectModelsByQueryCriteria", query, page);
    }

    public long findModelCountByQueryCriteria(ModelQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectModelCountByQueryCriteria", query);
    }

    public ModelEntity findModelById(String modelId) {
        return (ModelEntity)this.getDbSqlSession().selectOne("selectModel", modelId);
    }

    public byte[] findEditorSourceByModelId(String modelId) {
        ByteArrayEntity byteEntity;
        byte[] bytes = null;
        ModelEntity model = this.findModelById(modelId);
        if (model != null && model.getEditorSourceValueId() != null && (byteEntity = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, model.getEditorSourceValueId())) != null) {
            bytes = byteEntity.getBytes();
        }
        return bytes;
    }

    public byte[] findEditorSourceExtraByModelId(String modelId) {
        ByteArrayEntity byteEntity;
        byte[] bytes = null;
        ModelEntity model = this.findModelById(modelId);
        if (model != null && model.getEditorSourceExtraValueId() != null && (byteEntity = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, model.getEditorSourceExtraValueId())) != null) {
            bytes = byteEntity.getBytes();
        }
        return bytes;
    }
}

