/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.repository.Deployment;

public class DeploymentEntity
implements Serializable,
Deployment,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected String category;
    protected Map<String, ResourceEntity> resources;
    protected Date deploymentTime;
    protected boolean isNew;
    protected Map<Class<?>, List<Object>> deployedArtifacts;

    public ResourceEntity getResource(String resourceName) {
        return this.getResources().get(resourceName);
    }

    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public Map<String, ResourceEntity> getResources() {
        if (this.resources == null && this.id != null) {
            List<ResourceEntity> resourcesList = Context.getCommandContext().getResourceEntityManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, ResourceEntity>();
            for (ResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    @Override
    public Object getPersistentState() {
        return DeploymentEntity.class;
    }

    public void addDeployedArtifact(Object deployedArtifact) {
        Class<?> clazz;
        List<Object> artifacts;
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        if ((artifacts = this.deployedArtifacts.get(clazz = deployedArtifact.getClass())) == null) {
            artifacts = new ArrayList<Object>();
            this.deployedArtifacts.put(clazz, artifacts);
        }
        artifacts.add(deployedArtifact);
    }

    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        return this.deployedArtifacts.get(clazz);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    @Override
    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

