/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceUtils {
    private static Map<String, Collection<String>> TYPE_NAME = new HashMap<String, Collection<String>>();
    private static Map<String, String> NAME_TYPE = new HashMap<String, String>();

    private static void register(String type, String ... databaseProductNames) {
        TYPE_NAME.put(type, Arrays.asList(databaseProductNames));
        for (String databaseProductName : databaseProductNames) {
            NAME_TYPE.put(databaseProductName, type);
        }
    }

    public static String getDatabaseName(DataSource dataSource) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            if (con == null) {
                throw new RuntimeException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData == null) {
                throw new RuntimeException("DatabaseMetaData returned by Connection [" + con + "] was null");
            }
            String productName = metaData.getDatabaseProductName();
            String string = NAME_TYPE.get(productName);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get database product name", e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    static {
        DataSourceUtils.register("cache", "Cache");
        DataSourceUtils.register("db2", "DB2", "DB2 (DataDirect)");
        DataSourceUtils.register("generic", "DB2 for AS/400 (JTOpen)", "JDBC/ODBC Bridge", "McKoi");
        DataSourceUtils.register("firebird", "Firebird");
        DataSourceUtils.register("frontbase", "FrontBase");
        DataSourceUtils.register("neoview", "HP Neoview");
        DataSourceUtils.register("hsql", "HSQLDB server", "HSQLDB embedded");
        DataSourceUtils.register("h2", "H2 server", "H2 embedded");
        DataSourceUtils.register("informix", "Informix", "Informix (DataDirect)");
        DataSourceUtils.register("derby", "JavaDB/Derby server", "JavaDB/Derby embedded");
        DataSourceUtils.register("jdatastore", "JDataStore");
        DataSourceUtils.register("maxdb", "MaxDB");
        DataSourceUtils.register("mimer", "Mimer");
        DataSourceUtils.register("mysql", "MySQL");
        DataSourceUtils.register("netezza", "Netezza");
        DataSourceUtils.register("oracle", "Oracle Thin", "Oracle OCI", "Oracle (DataDirect)");
        DataSourceUtils.register("pervasive", "Pervasive");
        DataSourceUtils.register("postgresql", "PostgreSQL");
        DataSourceUtils.register("progress", "Progress");
        DataSourceUtils.register("sqlite", "SQLite");
        DataSourceUtils.register("sqlserver", "SQL Server (DataDirect)", "SQL Server (jTDS)", "SQL Server (Microsoft JDBC Driver)", "SQL Server 2008 (Microsoft JDBC Driver)");
        DataSourceUtils.register("sybase-ase", "Sybase ASE (jTDS)", "Sybase ASE (JConnect)", "Sybase SQL Anywhere (JConnect)");
        DataSourceUtils.register("sybase", "Sybase (DataDirect)");
    }
}

