/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.dynamic.OgnlCache;
import org.apache.ibatis.mapping.SqlMapperException;
import org.apache.ibatis.ognl.OgnlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluator {
    public boolean evaluateBoolean(String expression, Object parameterObject) {
        try {
            Object value = OgnlCache.getValue(expression, parameterObject);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return !new BigDecimal(String.valueOf(value)).equals(BigDecimal.ZERO);
            }
            return value != null;
        }
        catch (OgnlException e) {
            throw new BuilderException("Error evaluating expression '" + expression + "'. Cause: " + e, e);
        }
    }

    public Iterable<?> evaluateIterable(String expression, Object parameterObject) {
        try {
            Object value = OgnlCache.getValue(expression, parameterObject);
            if (value == null) {
                throw new SqlMapperException("The expression '" + expression + "' evaluated to a null value.");
            }
            if (value instanceof Iterable) {
                return (Iterable)value;
            }
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                ArrayList<Object> answer = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    Object o = Array.get(value, i);
                    answer.add(o);
                }
                return answer;
            }
            throw new BuilderException("Error evaluating expression '" + expression + "'.  Return value (" + value + ") was not iterable.");
        }
        catch (OgnlException e) {
            throw new BuilderException("Error evaluating expression '" + expression + "'. Cause: " + e, e);
        }
    }
}

