/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.UserRequestService;
import org.apache.syncope.common.to.UserRequestTO;
import org.springframework.web.client.RestTemplate;

public class UserRequestServiceProxy
extends SpringServiceProxy
implements UserRequestService {
    public UserRequestServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response getOptions() {
        return Response.ok().header("Allow", (Object)"GET,POST,OPTIONS,HEAD").header("Syncope-Create-Allowed", (Object)this.isCreateAllowed()).build();
    }

    public boolean isCreateAllowed() {
        return (Boolean)this.getRestTemplate().getForObject(this.baseUrl + "user/request/create/allowed.json", Boolean.class, new Object[0]);
    }

    public Response create(UserRequestTO userRequestTO) {
        UserRequestTO created;
        switch (userRequestTO.getType()) {
            case UPDATE: {
                created = (UserRequestTO)this.getRestTemplate().postForObject(this.baseUrl + "user/request/update", (Object)userRequestTO.getUserMod(), UserRequestTO.class, new Object[0]);
                break;
            }
            case DELETE: {
                created = (UserRequestTO)this.getRestTemplate().getForObject(this.baseUrl + "user/request/delete/{userId}", UserRequestTO.class, new Object[]{userRequestTO.getUserId()});
                break;
            }
            default: {
                created = (UserRequestTO)this.getRestTemplate().postForObject(this.baseUrl + "user/request/create", (Object)userRequestTO.getUserTO(), UserRequestTO.class, new Object[0]);
            }
        }
        URI location = URI.create(this.baseUrl + "user/request/read/" + created.getId() + ".json");
        return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)created.getId()).build();
    }

    public List<UserRequestTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "user/request/list.json", UserRequestTO[].class, new Object[0]));
    }

    public UserRequestTO read(Long requestId) {
        return (UserRequestTO)this.getRestTemplate().getForObject(this.baseUrl + "user/request/read/{requestId}.json", UserRequestTO.class, new Object[]{requestId});
    }

    public void delete(Long requestId) {
        this.getRestTemplate().getForObject(this.baseUrl + "user/request/deleteRequest/{requestId}.json", UserRequestTO.class, new Object[]{requestId});
    }
}

