/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineEnclosure
extends Enclosure {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InlineEnclosure.class);

    public InlineEnclosure(String id, String childId) {
        super(id, childId);
        this.setOutputMarkupPlaceholderTag(true);
        this.setMarkupId(this.getId());
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        tag.remove("enclosure");
        super.onComponentTag(tag);
    }

    public boolean updateVisibility() {
        boolean visible = this.getChild().determineVisibility();
        this.setVisible(visible);
        return visible;
    }

    private String getWicketNamespace() {
        IMarkupFragment markup;
        MarkupResourceStream markupResourceStream;
        String namespace;
        String markupNamespace = "wicket";
        Page page = this.findPage();
        if (page != null && !Strings.isEmpty((CharSequence)(namespace = (markupResourceStream = (markup = page.getMarkup()).getMarkupResourceStream()).getWicketNamespace()))) {
            markupNamespace = namespace;
        }
        return markupNamespace;
    }
}

