/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class AttributeInfo {
    private final String _name;
    private final Class<?> _type;
    private final Set<Flags> _flags;

    AttributeInfo(String name, Class<?> type, Set<Flags> flags) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalStateException("Name must not be blank!");
        }
        if ((OperationalAttributes.PASSWORD_NAME.equals(name) || OperationalAttributes.CURRENT_PASSWORD_NAME.equals(name)) && !GuardedString.class.equals(type)) {
            String MSG = "Password based attributes must be of type GuardedString.";
            throw new IllegalArgumentException("Password based attributes must be of type GuardedString.");
        }
        Assertions.nullCheck(flags, "flags");
        FrameworkUtil.checkAttributeType(type);
        this._name = name;
        this._type = type;
        this._flags = Collections.unmodifiableSet(EnumSet.copyOf(flags));
        if (!this.isReadable() && this.isReturnedByDefault()) {
            throw new IllegalArgumentException("Attribute " + name + " is flagged as not-readable, so it should also be as not-returned-by-default.");
        }
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Set<Flags> getFlags() {
        return this._flags;
    }

    public boolean isReadable() {
        return !this._flags.contains((Object)Flags.NOT_READABLE);
    }

    public boolean isCreateable() {
        return !this._flags.contains((Object)Flags.NOT_CREATABLE);
    }

    public boolean isUpdateable() {
        return !this._flags.contains((Object)Flags.NOT_UPDATEABLE);
    }

    public boolean isRequired() {
        return this._flags.contains((Object)Flags.REQUIRED);
    }

    public boolean isMultiValued() {
        return this._flags.contains((Object)Flags.MULTIVALUED);
    }

    public boolean isReturnedByDefault() {
        return !this._flags.contains((Object)Flags.NOT_RETURNED_BY_DEFAULT);
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this._name, name);
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof AttributeInfo) {
            AttributeInfo other = (AttributeInfo)obj;
            if (!this.is(other.getName())) {
                return false;
            }
            if (!this.getType().equals(other.getType())) {
                return false;
            }
            return CollectionUtil.equals(this._flags, other._flags);
        }
        return ret;
    }

    public int hashCode() {
        return NameUtil.nameHashCode(this._name);
    }

    public String toString() {
        return SerializerUtil.serializeXmlObject(this, false);
    }

    public static enum Flags {
        REQUIRED,
        MULTIVALUED,
        NOT_CREATABLE,
        NOT_UPDATEABLE,
        NOT_READABLE,
        NOT_RETURNED_BY_DEFAULT;

    }
}

