/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.validation;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.syncope.common.types.SyncopeClientExceptionType;
import org.apache.syncope.common.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.common.validation.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class SyncopeClientErrorHandler
extends DefaultResponseErrorHandler {
    public static final String EXCEPTION_TYPE_HEADER = "ExceptionType";
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeClientErrorHandler.class);
    private static final HttpStatus[] MANAGED_STATUSES = new HttpStatus[]{HttpStatus.BAD_REQUEST, HttpStatus.NOT_FOUND, HttpStatus.CONFLICT, HttpStatus.UNAUTHORIZED};

    public void handleError(ClientHttpResponse response) throws IOException {
        if (!ArrayUtils.contains((Object[])MANAGED_STATUSES, (Object)response.getStatusCode())) {
            super.handleError(response);
        }
        if (response.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED)) {
            throw new AccessControlException("Remote unauthorized exception");
        }
        List exceptionTypesInHeaders = response.getHeaders().get((Object)EXCEPTION_TYPE_HEADER);
        if (exceptionTypesInHeaders == null) {
            LOG.debug("No ExceptionType provided");
            return;
        }
        SyncopeClientCompositeErrorException compositeException = new SyncopeClientCompositeErrorException(response.getStatusCode());
        HashSet<String> handledExceptions = new HashSet<String>();
        for (String exceptionTypeAsString : exceptionTypesInHeaders) {
            SyncopeClientExceptionType exceptionType = null;
            try {
                exceptionType = SyncopeClientExceptionType.getFromHeaderValue(exceptionTypeAsString);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected value of ExceptionType: " + exceptionTypeAsString, (Throwable)e);
            }
            if (exceptionType == null) continue;
            handledExceptions.add(exceptionTypeAsString);
            SyncopeClientException clientException = new SyncopeClientException();
            clientException.setType(exceptionType);
            if (response.getHeaders().get((Object)exceptionType.getElementHeaderName()) != null && !response.getHeaders().get((Object)exceptionType.getElementHeaderName()).isEmpty()) {
                clientException.setElements(response.getHeaders().get((Object)exceptionType.getElementHeaderName()));
            }
            compositeException.addException(clientException);
        }
        exceptionTypesInHeaders.removeAll(handledExceptions);
        if (!exceptionTypesInHeaders.isEmpty()) {
            LOG.error("Unmanaged exceptions: " + exceptionTypesInHeaders);
        }
        if (compositeException.hasExceptions()) {
            throw compositeException;
        }
    }
}

