/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.InputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;

public class CreateAttachmentCmd
implements Command<Attachment> {
    protected String attachmentType;
    protected String taskId;
    protected String processInstanceId;
    protected String attachmentName;
    protected String attachmentDescription;
    protected InputStream content;
    protected String url;

    public CreateAttachmentCmd(String attachmentType, String taskId, String processInstanceId, String attachmentName, String attachmentDescription, InputStream content, String url) {
        this.attachmentType = attachmentType;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.attachmentName = attachmentName;
        this.attachmentDescription = attachmentDescription;
        this.content = content;
        this.url = url;
    }

    @Override
    public Attachment execute(CommandContext commandContext) {
        this.verifyParameters(commandContext);
        AttachmentEntity attachment = new AttachmentEntity();
        attachment.setName(this.attachmentName);
        attachment.setDescription(this.attachmentDescription);
        attachment.setType(this.attachmentType);
        attachment.setTaskId(this.taskId);
        attachment.setProcessInstanceId(this.processInstanceId);
        attachment.setUrl(this.url);
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.insert(attachment);
        if (this.content != null) {
            byte[] bytes = IoUtil.readInputStream(this.content, this.attachmentName);
            ByteArrayEntity byteArray = new ByteArrayEntity(bytes);
            dbSqlSession.insert(byteArray);
            attachment.setContentId(byteArray.getId());
        }
        commandContext.getHistoryManager().createAttachmentComment(this.taskId, this.processInstanceId, this.attachmentName, true);
        return attachment;
    }

    private void verifyParameters(CommandContext commandContext) {
        if (this.taskId != null) {
            TaskEntity task = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
            if (task == null) {
                throw new ActivitiObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
            }
            if (task.isSuspended()) {
                throw new ActivitiException("It is not allowed to add an attachment to a suspended task");
            }
        }
        if (this.processInstanceId != null) {
            ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
            if (execution == null) {
                throw new ActivitiObjectNotFoundException("Process instance " + this.processInstanceId + " doesn't exist", ProcessInstance.class);
            }
            if (execution.isSuspended()) {
                throw new ActivitiException("It is not allowed to add an attachment to a suspended process instance");
            }
        }
    }
}

