/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTypeHandler<T>
extends TypeReference<T>
implements TypeHandler<T> {
    protected Configuration configuration;

    public void setConfiguration(Configuration c) {
        this.configuration = c;
    }

    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new TypeException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            try {
                ps.setNull(i, jdbcType.TYPE_CODE);
            }
            catch (SQLException e) {
                throw new TypeException("Error setting null for parameter #" + i + " with JdbcType " + (Object)((Object)jdbcType) + " . " + "Try setting a different JdbcType for this parameter or a different jdbcTypeForNull configuration property. " + "Cause: " + e, e);
            }
        } else {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        T result = this.getNullableResult(rs, columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        T result = this.getNullableResult(rs, columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        T result = this.getNullableResult(cs, columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, JdbcType var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, int var2) throws SQLException;

    public abstract T getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

