/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.MembershipTO;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="user")
@XmlType
public class UserTO
extends AbstractAttributableTO {
    private static final long serialVersionUID = 7791304495192615740L;
    private String password;
    private List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private String status;
    private String token;
    private Date tokenExpireTime;
    private String username;
    private Date lastLoginDate;
    private Date creationDate;
    private Date changePwdDate;
    private Integer failedLogins;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean addMembership(MembershipTO membershipTO) {
        return this.memberships.add(membershipTO);
    }

    public boolean removeMembership(MembershipTO membershipTO) {
        return this.memberships.remove(membershipTO);
    }

    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<MembershipTO> memberships) {
        this.memberships = memberships;
    }

    @JsonIgnore
    public Map<Long, MembershipTO> getMembershipMap() {
        Map<Long, MembershipTO> result;
        if (this.getMemberships() == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<Long, MembershipTO>(this.getMemberships().size());
            for (MembershipTO membership : this.getMemberships()) {
                result.put(membership.getRoleId(), membership);
            }
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Date getTokenExpireTime() {
        return this.tokenExpireTime == null ? null : new Date(this.tokenExpireTime.getTime());
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        if (tokenExpireTime != null) {
            this.tokenExpireTime = new Date(tokenExpireTime.getTime());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getChangePwdDate() {
        return this.changePwdDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setChangePwdDate(Date changePwdDate) {
        this.changePwdDate = changePwdDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("password");
            }
        }.toString();
    }
}

