/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class TagTester {
    private final XmlTag openTag;
    private final XmlTag closeTag;
    private final XmlPullParser parser;

    private TagTester(XmlPullParser parser, XmlTag openTag, XmlTag closeTag) {
        this.parser = parser;
        this.openTag = openTag;
        this.closeTag = closeTag;
    }

    public String getName() {
        return this.openTag.getName();
    }

    public boolean hasAttribute(String attribute) {
        boolean hasAttribute = false;
        if (this.getAttribute(attribute) != null) {
            hasAttribute = true;
        }
        return hasAttribute;
    }

    public String getAttribute(String attribute) {
        String value = null;
        IValueMap attributeMap = this.openTag.getAttributes();
        if (attributeMap != null) {
            for (String attr : attributeMap.keySet()) {
                if (!attr.equalsIgnoreCase(attribute)) continue;
                value = attributeMap.getString(attr);
            }
        }
        return value;
    }

    public boolean getAttributeContains(String attribute, String partialValue) {
        String value;
        boolean contains = false;
        if (partialValue != null && (value = this.getAttribute(attribute)) != null && value.contains(partialValue)) {
            contains = true;
        }
        return contains;
    }

    public boolean getAttributeIs(String attribute, String expected) {
        boolean is = false;
        String val = this.getAttribute(attribute);
        if (val == null && expected == null || expected != null && expected.equals(val)) {
            is = true;
        }
        return is;
    }

    public boolean getAttributeEndsWith(String attribute, String expected) {
        String val;
        boolean endsWith = false;
        if (expected != null && (val = this.getAttribute(attribute)) != null && val.endsWith(expected)) {
            endsWith = true;
        }
        return endsWith;
    }

    public boolean hasChildTag(String tagName) {
        boolean hasChild;
        block5: {
            hasChild = false;
            if (Strings.isEmpty((CharSequence)tagName)) {
                throw new IllegalArgumentException("You need to provide a not empty/not null argument.");
            }
            if (this.openTag.isOpen()) {
                try {
                    int startPos = this.openTag.getPos() + this.openTag.getLength();
                    int endPos = this.closeTag.getPos();
                    String markup = ((Object)this.parser.getInput(startPos, endPos)).toString();
                    if (Strings.isEmpty((CharSequence)markup)) break block5;
                    XmlPullParser p = new XmlPullParser();
                    p.parse(markup);
                    XmlTag tag = null;
                    while ((tag = p.nextTag()) != null) {
                        if (!tagName.equalsIgnoreCase(tag.getName())) continue;
                        hasChild = true;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new WicketRuntimeException(e);
                }
            }
        }
        return hasChild;
    }

    public TagTester getChild(String attribute, String value) {
        String markup;
        TagTester childTag = null;
        if (this.openTag.isOpen() && !Strings.isEmpty((CharSequence)(markup = this.getMarkup()))) {
            childTag = TagTester.createTagByAttribute(markup, attribute, value);
        }
        return childTag;
    }

    public String getMarkup() {
        int openPos = this.openTag.getPos();
        int closePos = this.closeTag.getPos() + this.closeTag.getLength();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public String getValue() {
        int openPos = this.openTag.getPos() + this.openTag.getLength();
        int closePos = this.closeTag.getPos();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public static TagTester createTagByAttribute(String markup, String attribute, String value) {
        TagTester tester = null;
        if (!(Strings.isEmpty((CharSequence)markup) || Strings.isEmpty((CharSequence)attribute) || Strings.isEmpty((CharSequence)value))) {
            try {
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag elm = null;
                XmlTag openTag = null;
                XmlTag closeTag = null;
                int level = 0;
                while ((elm = parser.nextTag()) != null && closeTag == null) {
                    XmlTag xmlTag = elm;
                    if (openTag == null) {
                        IValueMap attributeMap = xmlTag.getAttributes();
                        for (Map.Entry entry : attributeMap.entrySet()) {
                            String attr = (String)entry.getKey();
                            if (!attr.equals(attribute) || !value.equals(entry.getValue())) continue;
                            if (xmlTag.isOpen()) {
                                openTag = xmlTag;
                                continue;
                            }
                            if (!xmlTag.isOpenClose()) continue;
                            openTag = xmlTag;
                            closeTag = xmlTag;
                        }
                        continue;
                    }
                    if (xmlTag.isOpen() && xmlTag.getName().equals(openTag.getName())) {
                        ++level;
                    }
                    if (!xmlTag.isClose() || !xmlTag.getName().equals(openTag.getName())) continue;
                    if (level == 0) {
                        closeTag = xmlTag;
                        closeTag.setOpenTag(openTag);
                        continue;
                    }
                    --level;
                }
                if (openTag != null && closeTag != null) {
                    tester = new TagTester(parser, openTag, closeTag);
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return tester;
    }

    public static TagTester createTagsByAttribute(String markup, String attribute, String value) {
        List<TagTester> tester = TagTester.createTagsByAttribute(markup, attribute, value, true);
        if (tester == null || tester.size() == 0) {
            return null;
        }
        return tester.get(0);
    }

    public static List<TagTester> createTagsByAttribute(String markup, String attribute, String value, boolean stopAfterFirst) {
        ArrayList<TagTester> testers = new ArrayList<TagTester>();
        if (!(Strings.isEmpty((CharSequence)markup) || Strings.isEmpty((CharSequence)attribute) || Strings.isEmpty((CharSequence)value))) {
            try {
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag elm = null;
                XmlTag openTag = null;
                XmlTag closeTag = null;
                int level = 0;
                while ((elm = parser.nextTag()) != null) {
                    XmlTag xmlTag = elm;
                    if (openTag == null) {
                        IValueMap attributeMap = xmlTag.getAttributes();
                        for (Map.Entry entry : attributeMap.entrySet()) {
                            if (!((String)entry.getKey()).equals(attribute) || !value.equals(entry.getValue())) continue;
                            if (xmlTag.isOpen()) {
                                openTag = xmlTag;
                                continue;
                            }
                            if (!xmlTag.isOpenClose()) continue;
                            openTag = xmlTag;
                            closeTag = xmlTag;
                        }
                    } else {
                        if (xmlTag.isOpen() && xmlTag.getName().equals(openTag.getName())) {
                            ++level;
                        }
                        if (xmlTag.isClose() && xmlTag.getName().equals(openTag.getName())) {
                            if (level == 0) {
                                closeTag = xmlTag;
                                closeTag.setOpenTag(openTag);
                            } else {
                                --level;
                            }
                        }
                    }
                    if (openTag != null && closeTag != null && level == 0) {
                        TagTester tester = new TagTester(parser, openTag, closeTag);
                        testers.add(tester);
                        openTag = null;
                        closeTag = null;
                    }
                    if (!stopAfterFirst || closeTag == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return testers;
    }
}

