/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.ConnConfProperty;

@Path(value="connectors")
public interface ConnectorService {
    @POST
    public Response create(ConnInstanceTO var1);

    @DELETE
    @Path(value="{connInstanceId}")
    public void delete(@PathParam(value="connInstanceId") Long var1);

    @GET
    @Path(value="bundles")
    public List<ConnBundleTO> getBundles(@QueryParam(value="lang") String var1);

    @GET
    @Path(value="{connInstanceId}/configuration")
    public List<ConnConfProperty> getConfigurationProperties(@PathParam(value="connInstanceId") Long var1);

    @POST
    @Path(value="{connInstanceId}/schemas")
    public List<SchemaTO> getSchemaNames(@PathParam(value="connInstanceId") Long var1, ConnInstanceTO var2, @QueryParam(value="showAll") @DefaultValue(value="false") boolean var3);

    @GET
    public List<ConnInstanceTO> list(@QueryParam(value="lang") String var1);

    @GET
    @Path(value="{connInstanceId}")
    public ConnInstanceTO read(@PathParam(value="connInstanceId") Long var1);

    @GET
    public ConnInstanceTO readByResource(@MatrixParam(value="resourceName") String var1);

    @PUT
    @Path(value="{connInstanceId}")
    public void update(@PathParam(value="connInstanceId") Long var1, ConnInstanceTO var2);

    @POST
    @Path(value="check")
    public boolean check(ConnInstanceTO var1);

    @POST
    @Path(value="reload")
    public void reload();

    @POST
    @Path(value="bulk")
    public BulkActionRes bulkAction(BulkAction var1);
}

