/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import java.net.URI;
import org.apache.syncope.sra.security.pac4j.NoOpSessionStore;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeHttpActionAdapter;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SAML2WebSsoAuthenticationRequestWebFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2WebSsoAuthenticationRequestWebFilter.class);
    public static final String AUTHENTICATE_URL = "/saml2/authenticate";
    private static final ServerWebExchangeMatcher MATCHER = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/saml2/authenticate"});
    private final SAML2Client saml2Client;

    public SAML2WebSsoAuthenticationRequestWebFilter(SAML2Client saml2Client) {
        this.saml2Client = saml2Client;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return MATCHER.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(r -> exchange.getSession()).flatMap(session -> {
            LOG.debug("Creating SAML2 SP Authentication Request for IDP[{}]", (Object)this.saml2Client.getIdentityProviderResolvedEntityId());
            this.saml2Client.setStateGenerator(ctx -> ((URI)session.getRequiredAttribute("INITIAL_REQUEST_URI")).toASCIIString());
            ServerWebExchangeContext swec = new ServerWebExchangeContext(exchange);
            return this.saml2Client.getRedirectionAction(new CallContext((WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE)).map(action -> ServerWebExchangeHttpActionAdapter.INSTANCE.adapt((HttpAction)action, swec)).orElseThrow(() -> new IllegalStateException("No action generated"));
        }).onErrorResume(Mono::error);
    }
}

