/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.pac4j;

import java.net.URI;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public final class RedirectionActionUtils {
    public static Mono<Void> handle(RedirectionAction action, ServerWebExchangeContext swec) {
        if (action instanceof WithLocationAction) {
            WithLocationAction withLocationAction = (WithLocationAction)action;
            swec.getNative().getResponse().setStatusCode(HttpStatus.FOUND);
            swec.getNative().getResponse().getHeaders().setLocation(URI.create(withLocationAction.getLocation()));
            return swec.getNative().getResponse().setComplete();
        }
        if (action instanceof WithContentAction) {
            WithContentAction withContentAction = (WithContentAction)action;
            String content = withContentAction.getContent();
            if (content == null) {
                throw new IllegalArgumentException("No content set for POST AuthnRequest");
            }
            return Mono.defer(() -> {
                swec.getNative().getResponse().getHeaders().setContentType(MediaType.TEXT_HTML);
                return swec.getNative().getResponse().writeWith((Publisher)Mono.just((Object)swec.getNative().getResponse().bufferFactory().wrap(content.getBytes())));
            });
        }
        throw new IllegalArgumentException("Unsupported Action: " + action.getClass().getName());
    }

    private RedirectionActionUtils() {
    }
}

