/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.sra.security.AbstractRouteMatcher;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CsrfRouteMatcher
extends AbstractRouteMatcher {
    private static final String CACHE_NAME = CsrfRouteMatcher.class.getName();
    private static final Set<HttpMethod> ALLOWED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE, HttpMethod.OPTIONS);
    private final PublicRouteMatcher publicRouteMatcher;

    public CsrfRouteMatcher(PublicRouteMatcher publicRouteMatcher) {
        this.publicRouteMatcher = publicRouteMatcher;
    }

    @Override
    protected String getCacheName() {
        return CACHE_NAME;
    }

    @Override
    protected boolean routeBehavior(Route route) {
        return this.routeProvider.getRouteTOs().stream().filter(r -> route.getId().equals(r.getKey())).findFirst().map(SRARouteTO::isCsrf).orElse(true) != false && !this.publicRouteMatcher.routeBehavior(route);
    }

    @Override
    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
        return Mono.just((Object)exchange.getRequest()).map(HttpRequest::getMethod).filter(ALLOWED_METHODS::contains).flatMap(m -> ServerWebExchangeMatcher.MatchResult.notMatch()).switchIfEmpty(super.matches(exchange));
    }

    static {
        CACHE.put(CACHE_NAME, new ConcurrentHashMap());
    }
}

