/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.buildtools;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifURLLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LdifURLLoader.class);
    protected CoreSession coreSession;
    protected URL ldif;
    private int count;

    public LdifURLLoader(CoreSession coreSession, URL ldif) {
        this.coreSession = coreSession;
        this.ldif = ldif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        Object rdn = null;
        InputStream in = null;
        try {
            in = this.ldif.openStream();
            for (LdifEntry ldifEntry : new LdifReader(in)) {
                DN dn = ldifEntry.getDn();
                if (ldifEntry.isEntry()) {
                    Entry entry = ldifEntry.getEntry();
                    try {
                        this.coreSession.lookup(dn);
                        LOG.info("Found {}, will not create.", rdn);
                    }
                    catch (Exception e) {
                        try {
                            this.coreSession.add((ServerEntry)new DefaultServerEntry(this.coreSession.getDirectoryService().getSchemaManager(), entry));
                            ++this.count;
                            LOG.info("Created {}.", rdn);
                        }
                        catch (NamingException ne) {
                            LOG.info("Could not create entry {}", (Object)entry, (Object)ne);
                        }
                    }
                    continue;
                }
                List items = ldifEntry.getModificationItems();
                try {
                    this.coreSession.modify(dn, items);
                    LOG.info("Modified: " + dn + " with modificationItems: " + items);
                }
                catch (NamingException e) {
                    LOG.info("Could not modify: " + dn + " with modificationItems: " + items, (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err((String)I18n.ERR_173, (Object[])new Object[0]));
        }
        catch (Exception ioe) {
            LOG.error(I18n.err((String)I18n.ERR_174, (Object[])new Object[0]), (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err((String)I18n.ERR_175, (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        return this.count;
    }
}

