/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.Base64;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.SAML2SP4UIIdPTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SP4UIIdPDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIEntityFactory;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIUserTemplate;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.data.SAML2SP4UIIdPDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2SP4UIIdPDataBinderImpl
implements SAML2SP4UIIdPDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(SAML2SP4UIIdPDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final SAML2SP4UIIdPDAO idapDAO;
    protected final ImplementationDAO implementationDAO;
    protected final SAML2SP4UIEntityFactory entityFactory;
    protected final IntAttrNameParser intAttrNameParser;

    public SAML2SP4UIIdPDataBinderImpl(AnyTypeDAO anyTypeDAO, SAML2SP4UIIdPDAO idapDAO, ImplementationDAO implementationDAO, SAML2SP4UIEntityFactory entityFactory, IntAttrNameParser intAttrNameParser) {
        this.anyTypeDAO = anyTypeDAO;
        this.idapDAO = idapDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
        this.intAttrNameParser = intAttrNameParser;
    }

    public SAML2SP4UIIdP create(SAML2SP4UIIdPTO idpTO) {
        return this.update((SAML2SP4UIIdP)this.entityFactory.newEntity(SAML2SP4UIIdP.class), idpTO);
    }

    protected void populateItems(SAML2SP4UIIdPTO idpTO, SAML2SP4UIIdP idp) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        idpTO.getItems().forEach(itemTO -> {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)Item.class.getSimpleName());
                invalidMapping.getElements().add("Null " + Item.class.getSimpleName());
            } else if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
            } else {
                IntAttrName intAttrName = null;
                try {
                    intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), AnyTypeKind.USER);
                }
                catch (ParseException e) {
                    LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)itemTO.getIntAttrName(), (Object)e);
                }
                if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null) {
                    LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                    invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not existing");
                } else {
                    if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                        SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                        invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                        scce.addException(invalidMandatoryCondition);
                    }
                    Item item = new Item();
                    item.setIntAttrName(itemTO.getIntAttrName());
                    item.setExtAttrName(itemTO.getExtAttrName());
                    item.setMandatoryCondition(itemTO.getMandatoryCondition());
                    item.setConnObjectKey(itemTO.isConnObjectKey());
                    item.setPassword(itemTO.isPassword());
                    item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                    item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                    item.setPurpose(MappingPurpose.NONE);
                    itemTO.getTransformers().forEach(transformerKey -> {
                        this.implementationDAO.findById(transformerKey).ifPresentOrElse(transformer -> item.getTransformers().add(transformer.getKey()), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), transformerKey));
                        item.getTransformers().removeIf(implementation -> !itemTO.getTransformers().contains(implementation));
                    });
                    if (item.isConnObjectKey()) {
                        if ("password".equals(intAttrName.getField())) {
                            invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                        }
                        idp.setConnObjectKeyItem(item);
                    } else {
                        idp.getItems().add(item);
                    }
                }
            }
        });
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public SAML2SP4UIIdP update(SAML2SP4UIIdP idp, SAML2SP4UIIdPTO idpTO) {
        idp.setEntityID(idpTO.getEntityID());
        idp.setName(idpTO.getName());
        idp.setMetadata(Base64.getMimeDecoder().decode(idpTO.getMetadata()));
        idp.setLogoutSupported(idpTO.isLogoutSupported());
        idp.setCreateUnmatching(idpTO.isCreateUnmatching());
        idp.setSelfRegUnmatching(idpTO.isSelfRegUnmatching());
        idp.setUpdateMatching(idpTO.isUpdateMatching());
        idp.setBindingType(idpTO.getBindingType());
        if (idpTO.getRequestedAuthnContextProvider() == null) {
            idp.setRequestedAuthnContextProvider(null);
        } else {
            this.implementationDAO.findById(idpTO.getRequestedAuthnContextProvider()).ifPresentOrElse(arg_0 -> ((SAML2SP4UIIdP)idp).setRequestedAuthnContextProvider(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), (Object)idpTO.getRequestedAuthnContextProvider()));
        }
        if (idpTO.getUserTemplate() == null) {
            idp.setUserTemplate(null);
        } else {
            SAML2SP4UIUserTemplate userTemplate = idp.getUserTemplate();
            if (userTemplate == null) {
                userTemplate = (SAML2SP4UIUserTemplate)this.entityFactory.newEntity(SAML2SP4UIUserTemplate.class);
                userTemplate.setAnyType(this.anyTypeDAO.getUser());
                userTemplate.setIdP(idp);
                idp.setUserTemplate(userTemplate);
            }
            userTemplate.set((AnyTO)idpTO.getUserTemplate());
        }
        idp.getItems().clear();
        this.populateItems(idpTO, idp);
        idpTO.getActions().forEach(action -> this.implementationDAO.findById(action).ifPresentOrElse(arg_0 -> ((SAML2SP4UIIdP)idp).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), action)));
        idp.getActions().removeIf(impl -> !idpTO.getActions().contains(impl.getKey()));
        return (SAML2SP4UIIdP)this.idapDAO.save((Entity)idp);
    }

    protected void populateItems(SAML2SP4UIIdP idp, SAML2SP4UIIdPTO idpTO) {
        idp.getItems().forEach(item -> {
            Item itemTO = new Item();
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            itemTO.getTransformers().addAll(item.getTransformers());
            itemTO.setPurpose(MappingPurpose.NONE);
            if (itemTO.isConnObjectKey()) {
                idpTO.setConnObjectKeyItem(itemTO);
            } else {
                idpTO.add(itemTO);
            }
        });
    }

    public SAML2SP4UIIdPTO getIdPTO(SAML2SP4UIIdP idp) {
        SAML2SP4UIIdPTO idpTO = new SAML2SP4UIIdPTO();
        idpTO.setKey(idp.getKey());
        idpTO.setEntityID(idp.getEntityID());
        idpTO.setName(idp.getName());
        idpTO.setMetadata(Base64.getMimeEncoder().encodeToString(idp.getMetadata()));
        idpTO.setLogoutSupported(idp.isLogoutSupported());
        idpTO.setBindingType(idp.getBindingType());
        idpTO.setCreateUnmatching(idp.isCreateUnmatching());
        idpTO.setSelfRegUnmatching(idp.isSelfRegUnmatching());
        idpTO.setUpdateMatching(idp.isUpdateMatching());
        if (idp.getRequestedAuthnContextProvider() != null) {
            idpTO.setRequestedAuthnContextProvider(idp.getRequestedAuthnContextProvider().getKey());
        }
        if (idp.getUserTemplate() != null) {
            idpTO.setUserTemplate((UserTO)idp.getUserTemplate().get());
        }
        this.populateItems(idp, idpTO);
        idpTO.getActions().addAll(idp.getActions().stream().map(Entity::getKey).toList());
        return idpTO;
    }
}

