/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexManager;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class OpenSearchReindex
extends AbstractSchedTaskJobDelegate<SchedTask> {
    @Autowired
    protected OpenSearchClient client;
    @Autowired
    protected OpenSearchIndexManager indexManager;
    @Autowired
    protected OpenSearchUtils utils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected RealmDAO realmDAO;

    protected IndexSettings userSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings groupSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings anyObjectSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings realmSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings auditSettings() {
        return this.indexManager.defaultSettings();
    }

    protected TypeMapping userMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping groupMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping anyObjectMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping realmMapping() {
        return this.indexManager.defaultRealmMapping();
    }

    protected TypeMapping auditMapping() {
        return this.indexManager.defaultAuditMapping();
    }

    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        if (!context.isDryRun()) {
            this.setStatus("Start rebuilding indexes");
            try {
                this.indexManager.createRealmIndex(AuthContextUtils.getDomain(), this.realmSettings(), this.realmMapping());
                long realms = this.realmDAO.count();
                String rindex = OpenSearchUtils.getRealmIndex((String)AuthContextUtils.getDomain());
                this.setStatus("Indexing " + realms + " realms under " + rindex + "...");
                int page = 0;
                while ((long)page <= realms / 500L) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (Realm realm : this.realmDAO.findAll((Pageable)pageable)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(rindex)).id(realm.getKey())).document((Object)this.utils.document(realm))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{rindex, page, 500, response});
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{rindex, page, 500, e});
                    }
                    ++page;
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.USER, this.userSettings(), this.userMapping());
                long users = this.userDAO.count();
                String uindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.USER);
                this.setStatus("Indexing " + users + " users under " + uindex + "...");
                int page2 = 0;
                while ((long)page2 <= users / 500L) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    PageRequest pageable = PageRequest.of((int)page2, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (User user : this.userDAO.findAll((Pageable)pageable)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(uindex)).id(user.getKey())).document((Object)this.utils.document((Any)user))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{uindex, page2, 500, response});
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{uindex, page2, 500, e});
                    }
                    ++page2;
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.GROUP, this.groupSettings(), this.groupMapping());
                long groups = this.groupDAO.count();
                String gindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.GROUP);
                this.setStatus("Indexing " + groups + " groups under " + gindex + "...");
                int page3 = 0;
                while ((long)page3 <= groups / 500L) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    PageRequest pageable = PageRequest.of((int)page3, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (Group group : this.groupDAO.findAll((Pageable)pageable)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(gindex)).id(group.getKey())).document((Object)this.utils.document((Any)group))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{gindex, page3, 500, response});
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{gindex, page3, 500, e});
                    }
                    ++page3;
                }
                this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.ANY_OBJECT, this.anyObjectSettings(), this.anyObjectMapping());
                long anyObjects = this.anyObjectDAO.count();
                String aindex = OpenSearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.ANY_OBJECT);
                this.setStatus("Indexing " + anyObjects + " any objects under " + aindex + "...");
                int page4 = 0;
                while ((long)page4 <= anyObjects / 500L) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
                    PageRequest pageable = PageRequest.of((int)page4, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (AnyObject anyObject : this.anyObjectDAO.findAll((Pageable)pageable)) {
                        bulkRequest.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(aindex)).id(anyObject.getKey())).document((Object)this.utils.document((Any)anyObject))));
                    }
                    try {
                        BulkResponse response = this.client.bulk(bulkRequest.build());
                        LOG.debug("Index successfully created for {} [{}/{}]: {}", new Object[]{aindex, page4, 500, response});
                    }
                    catch (Exception e) {
                        LOG.error("Could not create index for {} [{}/{}]: {}", new Object[]{aindex, page4, 500, e});
                    }
                    ++page4;
                }
                this.indexManager.createAuditIndex(AuthContextUtils.getDomain(), this.auditSettings(), this.auditMapping());
                this.setStatus("Rebuild indexes for domain " + AuthContextUtils.getDomain() + " successfully completed");
                return "Indexes created:\n " + rindex + " [" + realms + "]\n " + uindex + " [" + users + "]\n " + gindex + " [" + groups + "]\n " + aindex + " [" + anyObjects + "]\n " + OpenSearchUtils.getAuditIndex((String)AuthContextUtils.getDomain());
            }
            catch (Exception e) {
                throw new JobExecutionException("While rebuilding index for domain " + AuthContextUtils.getDomain(), (Throwable)e);
            }
        }
        return "SUCCESS";
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }
}

