/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Leaf;
import org.apache.syncope.ext.openfga.client.model.Nodes;
import org.apache.syncope.ext.openfga.client.model.UsersetTreeDifference;

@JsonPropertyOrder(value={"name", "leaf", "difference", "union", "intersection"})
public class Node {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_LEAF = "leaf";
    @Nullable
    private Leaf leaf;
    public static final String JSON_PROPERTY_DIFFERENCE = "difference";
    @Nullable
    private UsersetTreeDifference difference;
    public static final String JSON_PROPERTY_UNION = "union";
    @Nullable
    private Nodes union;
    public static final String JSON_PROPERTY_INTERSECTION = "intersection";
    @Nullable
    private Nodes intersection;

    public Node name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Node leaf(@Nullable Leaf leaf) {
        this.leaf = leaf;
        return this;
    }

    @Nullable
    @JsonProperty(value="leaf", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Leaf getLeaf() {
        return this.leaf;
    }

    @JsonProperty(value="leaf", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeaf(@Nullable Leaf leaf) {
        this.leaf = leaf;
    }

    public Node difference(@Nullable UsersetTreeDifference difference) {
        this.difference = difference;
        return this;
    }

    @Nullable
    @JsonProperty(value="difference", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsersetTreeDifference getDifference() {
        return this.difference;
    }

    @JsonProperty(value="difference", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDifference(@Nullable UsersetTreeDifference difference) {
        this.difference = difference;
    }

    public Node union(@Nullable Nodes union) {
        this.union = union;
        return this;
    }

    @Nullable
    @JsonProperty(value="union", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Nodes getUnion() {
        return this.union;
    }

    @JsonProperty(value="union", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnion(@Nullable Nodes union) {
        this.union = union;
    }

    public Node intersection(@Nullable Nodes intersection) {
        this.intersection = intersection;
        return this;
    }

    @Nullable
    @JsonProperty(value="intersection", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Nodes getIntersection() {
        return this.intersection;
    }

    @JsonProperty(value="intersection", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntersection(@Nullable Nodes intersection) {
        this.intersection = intersection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.name, node.name) && Objects.equals(this.leaf, node.leaf) && Objects.equals(this.difference, node.difference) && Objects.equals(this.union, node.union) && Objects.equals(this.intersection, node.intersection);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.leaf, this.difference, this.union, this.intersection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Node {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    leaf: ").append(this.toIndentedString(this.leaf)).append("\n");
        sb.append("    difference: ").append(this.toIndentedString(this.difference)).append("\n");
        sb.append("    union: ").append(this.toIndentedString(this.union)).append("\n");
        sb.append("    intersection: ").append(this.toIndentedString(this.intersection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format(Locale.ROOT, "%sname%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getName()))));
        }
        if (this.getLeaf() != null) {
            joiner.add(this.getLeaf().toUrlQueryString((String)prefix + JSON_PROPERTY_LEAF + suffix));
        }
        if (this.getDifference() != null) {
            joiner.add(this.getDifference().toUrlQueryString((String)prefix + JSON_PROPERTY_DIFFERENCE + suffix));
        }
        if (this.getUnion() != null) {
            joiner.add(this.getUnion().toUrlQueryString((String)prefix + JSON_PROPERTY_UNION + suffix));
        }
        if (this.getIntersection() != null) {
            joiner.add(this.getIntersection().toUrlQueryString((String)prefix + JSON_PROPERTY_INTERSECTION + suffix));
        }
        return joiner.toString();
    }
}

