/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.AssertionTupleKey;
import org.apache.syncope.ext.openfga.client.model.TupleKey;

@JsonPropertyOrder(value={"tuple_key", "expectation", "contextual_tuples", "context"})
public class Assertion {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nonnull
    private AssertionTupleKey tupleKey;
    public static final String JSON_PROPERTY_EXPECTATION = "expectation";
    @Nonnull
    private Boolean expectation;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    @Nullable
    private List<TupleKey> contextualTuples = new ArrayList<TupleKey>();
    public static final String JSON_PROPERTY_CONTEXT = "context";
    @Nullable
    private Object context;

    public Assertion tupleKey(@Nonnull AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssertionTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(@Nonnull AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public Assertion expectation(@Nonnull Boolean expectation) {
        this.expectation = expectation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getExpectation() {
        return this.expectation;
    }

    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpectation(@Nonnull Boolean expectation) {
        this.expectation = expectation;
    }

    public Assertion contextualTuples(@Nullable List<TupleKey> contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    public Assertion addContextualTuplesItem(TupleKey contextualTuplesItem) {
        if (this.contextualTuples == null) {
            this.contextualTuples = new ArrayList<TupleKey>();
        }
        this.contextualTuples.add(contextualTuplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TupleKey> getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(@Nullable List<TupleKey> contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public Assertion context(@Nullable Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(@Nullable Object context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assertion assertion = (Assertion)o;
        return Objects.equals(this.tupleKey, assertion.tupleKey) && Objects.equals(this.expectation, assertion.expectation) && Objects.equals(this.contextualTuples, assertion.contextualTuples) && Objects.equals(this.context, assertion.context);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.expectation, this.contextualTuples, this.context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Assertion {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    expectation: ").append(this.toIndentedString(this.expectation)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getExpectation() != null) {
            joiner.add(String.format("%sexpectation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getExpectation()))));
        }
        if (this.getContextualTuples() != null) {
            for (int i = 0; i < this.getContextualTuples().size(); ++i) {
                if (this.getContextualTuples().get(i) == null) continue;
                joiner.add(this.getContextualTuples().get(i).toUrlQueryString(String.format("%scontextual_tuples%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContext()))));
        }
        return joiner.toString();
    }
}

