/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.api.AuthorizationModelsApi;
import org.apache.syncope.ext.openfga.client.api.RelationshipQueriesApi;
import org.apache.syncope.ext.openfga.client.api.RelationshipTuplesApi;
import org.apache.syncope.ext.openfga.client.api.StoresApi;
import org.apache.syncope.ext.openfga.client.model.AuthorizationModel;
import org.apache.syncope.ext.openfga.client.model.CheckRequest;
import org.apache.syncope.ext.openfga.client.model.CheckResponse;
import org.apache.syncope.ext.openfga.client.model.CreateStoreRequest;
import org.apache.syncope.ext.openfga.client.model.CreateStoreResponse;
import org.apache.syncope.ext.openfga.client.model.GetStoreResponse;
import org.apache.syncope.ext.openfga.client.model.ListStoresResponse;
import org.apache.syncope.ext.openfga.client.model.ReadAuthorizationModelsResponse;
import org.apache.syncope.ext.openfga.client.model.ReadRequest;
import org.apache.syncope.ext.openfga.client.model.ReadResponse;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelRequest;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelResponse;
import org.apache.syncope.ext.openfga.client.model.WriteRequest;

public class OpenFGAClient {
    protected final StoresApi storesApi;
    protected final AuthorizationModelsApi authorizationModelsApi;
    protected final RelationshipTuplesApi relationshipTuplesApi;
    protected final RelationshipQueriesApi relationshipQueriesApi;
    protected String storeId;
    protected String authorizationModelId;

    public OpenFGAClient(ApiClient apiClient) {
        this.storesApi = new StoresApi(apiClient);
        this.authorizationModelsApi = new AuthorizationModelsApi(apiClient);
        this.relationshipTuplesApi = new RelationshipTuplesApi(apiClient);
        this.relationshipQueriesApi = new RelationshipQueriesApi(apiClient);
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public GetStoreResponse getStore() throws ApiException {
        return this.storesApi.getStore(this.storeId);
    }

    public ListStoresResponse listStores() throws ApiException {
        return this.storesApi.listStores(null, null, null);
    }

    public ApiResponse<ListStoresResponse> listStoresWithHttpInfo() throws ApiException {
        return this.storesApi.listStoresWithHttpInfo(null, null, null);
    }

    public CreateStoreResponse createStore(CreateStoreRequest request) throws ApiException {
        return this.storesApi.createStore(request);
    }

    public WriteAuthorizationModelResponse writeAuthorizationModel(WriteAuthorizationModelRequest request) throws ApiException {
        return this.authorizationModelsApi.writeAuthorizationModel(this.storeId, request);
    }

    public ReadAuthorizationModelsResponse readAuthorizationModels() throws ApiException {
        return this.authorizationModelsApi.readAuthorizationModels(this.storeId, null, null);
    }

    public AuthorizationModel readLatestAuthorizationModel() throws ApiException {
        return this.readAuthorizationModels().getAuthorizationModels().get(0);
    }

    public ReadResponse read(ReadRequest request) throws ApiException {
        return this.relationshipTuplesApi.read(this.storeId, request);
    }

    public void write(WriteRequest request) throws ApiException {
        this.relationshipTuplesApi.write(this.storeId, request);
    }

    public CheckResponse check(CheckRequest request) throws ApiException {
        return this.relationshipQueriesApi.check(this.storeId, request);
    }
}

