/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.panels;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.common.rest.api.service.OIDCC4UIProviderService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCSSOLoginFormPanel
extends BaseSSOLoginFormPanel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOIDCSSOLoginFormPanel.class);
    private static final long serialVersionUID = -7756088163755119603L;

    public AbstractOIDCSSOLoginFormPanel(String id, BaseSession session) {
        super(id);
        List available = ((OIDCC4UIProviderService)session.getAnonymousService(OIDCC4UIProviderService.class)).list();
        final Model model = new Model();
        AjaxDropDownChoicePanel ops = new AjaxDropDownChoicePanel("ops", "OpenID Connect", (IModel)model, false);
        ops.setChoices(available);
        ops.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<OIDCC4UIProviderTO>(){
            private static final long serialVersionUID = 1814750973898916102L;

            public Object getDisplayValue(OIDCC4UIProviderTO object) {
                return object.getName();
            }

            public String getIdValue(OIDCC4UIProviderTO object, int index) {
                return object.getName();
            }

            public OIDCC4UIProviderTO getObject(String id, IModel<? extends List<? extends OIDCC4UIProviderTO>> choices) {
                return ((List)choices.getObject()).stream().filter(object -> object.getName().equals(id)).findFirst().orElse(null);
            }
        });
        ops.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (model.getObject() != null) {
                    try {
                        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new RedirectRequestHandler(UrlUtils.rewriteToContextRelative((String)("oidcc4ui/login?op=" + URLEncoder.encode(((OIDCC4UIProviderTO)model.getObject()).getName(), StandardCharsets.UTF_8) + "&reauth=" + AbstractOIDCSSOLoginFormPanel.this.reauth), (IRequestCycle)RequestCycle.get())));
                    }
                    catch (Exception e) {
                        LOG.error("Could not redirect to the selected OP {}", (Object)((OIDCC4UIProviderTO)model.getObject()).getName(), (Object)e);
                    }
                }
            }
        }});
        ops.setOutputMarkupPlaceholderTag(true);
        ops.setVisible(!available.isEmpty());
        this.add(new Component[]{ops});
    }
}

