/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkIngester;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkListener;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexManager;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ElasticsearchReindex
extends AbstractSchedTaskJobDelegate<SchedTask> {
    @Autowired
    protected ElasticsearchClient client;
    @Autowired
    protected ElasticsearchIndexManager indexManager;
    @Autowired
    protected ElasticsearchUtils utils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected RealmDAO realmDAO;

    protected IndexSettings userSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings groupSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings anyObjectSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings realmSettings() {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings auditSettings() {
        return this.indexManager.defaultSettings();
    }

    protected TypeMapping userMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping groupMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping anyObjectMapping() {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping realmMapping() {
        return this.indexManager.defaultRealmMapping();
    }

    protected TypeMapping auditMapping() {
        return this.indexManager.defaultAuditMapping();
    }

    protected Pair<String, Long> reindexRealms(JobExecutionContext context) throws IOException {
        this.indexManager.createRealmIndex(AuthContextUtils.getDomain(), this.realmSettings(), this.realmMapping());
        long count = this.realmDAO.count();
        String index = ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain());
        this.setStatus("Indexing " + count + " realms under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            int page = 0;
            while ((long)page <= count / 500L) {
                PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                for (Realm realm : this.realmDAO.findAll((Pageable)pageable)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(realm.getKey())).document((Object)this.utils.document(realm))));
                }
                ++page;
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Long> reindexUsers(JobExecutionContext context) throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.USER, this.userSettings(), this.userMapping());
        long count = this.userDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.USER);
        this.setStatus("Indexing " + count + " users under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            int page = 0;
            while ((long)page <= count / 500L) {
                PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                for (User user : this.userDAO.findAll((Pageable)pageable)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(user.getKey())).document((Object)this.utils.document((Any)user))));
                }
                ++page;
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Long> reindexGroups(JobExecutionContext context) throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.GROUP, this.groupSettings(), this.groupMapping());
        long count = this.groupDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.GROUP);
        this.setStatus("Indexing " + count + " groups under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            int page = 0;
            while ((long)page <= count / 500L) {
                PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                for (Group group : this.groupDAO.findAll((Pageable)pageable)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(group.getKey())).document((Object)this.utils.document((Any)group))));
                }
                ++page;
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Long> reindexAnyObjects(JobExecutionContext context) throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.ANY_OBJECT, this.anyObjectSettings(), this.anyObjectMapping());
        long count = this.anyObjectDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.ANY_OBJECT);
        this.setStatus("Indexing " + count + " any objects under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            int page = 0;
            while ((long)page <= count / 500L) {
                PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                for (AnyObject anyObject : this.anyObjectDAO.findAll((Pageable)pageable)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(anyObject.getKey())).document((Object)this.utils.document((Any)anyObject))));
                }
                ++page;
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected String reindexAudit(JobExecutionContext context) throws IOException {
        this.indexManager.createAuditIndex(AuthContextUtils.getDomain(), this.auditSettings(), this.auditMapping());
        return ElasticsearchUtils.getAuditIndex((String)AuthContextUtils.getDomain());
    }

    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        if (!context.isDryRun()) {
            this.setStatus("Start rebuilding indexes");
            try {
                Pair<String, Long> rindex = this.reindexRealms(context);
                Pair<String, Long> uindex = this.reindexUsers(context);
                Pair<String, Long> gindex = this.reindexGroups(context);
                Pair<String, Long> aindex = this.reindexAnyObjects(context);
                String audit = this.reindexAudit(context);
                this.setStatus("Rebuild indexes for domain " + AuthContextUtils.getDomain() + " successfully completed");
                return "Indexes created:\n " + (String)rindex.getLeft() + " [" + String.valueOf(rindex.getRight()) + "]\n " + (String)uindex.getLeft() + " [" + String.valueOf(uindex.getRight()) + "]\n " + (String)gindex.getLeft() + " [" + String.valueOf(gindex.getRight()) + "]\n " + (String)aindex.getLeft() + " [" + String.valueOf(aindex.getRight()) + "]\n " + audit;
            }
            catch (Exception e) {
                throw new JobExecutionException("While rebuilding index for domain " + AuthContextUtils.getDomain(), (Throwable)e);
            }
        }
        return "SUCCESS";
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }

    protected static class ErrorLoggingBulkListener
    implements BulkListener<Void> {
        protected static final ErrorLoggingBulkListener INSTANCE = new ErrorLoggingBulkListener();

        protected ErrorLoggingBulkListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request, List<Void> contexts) {
        }

        public void afterBulk(long executionId, BulkRequest request, List<Void> contexts, BulkResponse response) {
            if (response.errors()) {
                String details = response.items().stream().map(BulkResponseItem::error).filter(Objects::nonNull).map(ErrorCause::toString).collect(Collectors.joining(", "));
                AbstractSchedTaskJobDelegate.LOG.error("Errors found for request {}; details: {}", (Object)executionId, (Object)details);
            }
        }

        public void afterBulk(long executionId, BulkRequest request, List<Void> contexts, Throwable failure) {
            AbstractSchedTaskJobDelegate.LOG.error("Bulk request {} failed", (Object)executionId, (Object)failure);
        }
    }
}

