/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkIngester;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkListener;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexManager;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchReindex
extends AbstractSchedTaskJobDelegate<SchedTask> {
    @Autowired
    protected ElasticsearchClient client;
    @Autowired
    protected ElasticsearchIndexManager indexManager;
    @Autowired
    protected ElasticsearchUtils utils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected RealmDAO realmDAO;

    protected IndexSettings userSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings groupSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings anyObjectSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings realmSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected IndexSettings auditSettings() throws IOException {
        return this.indexManager.defaultSettings();
    }

    protected TypeMapping userMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping groupMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping anyObjectMapping() throws IOException {
        return this.indexManager.defaultAnyMapping();
    }

    protected TypeMapping realmMapping() throws IOException {
        return this.indexManager.defaultRealmMapping();
    }

    protected TypeMapping auditMapping() throws IOException {
        return this.indexManager.defaultAuditMapping();
    }

    protected Pair<String, Integer> reindexRealms() throws IOException {
        this.indexManager.createRealmIndex(AuthContextUtils.getDomain(), this.realmSettings(), this.realmMapping());
        int count = this.realmDAO.count();
        String index = ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain());
        this.setStatus("Indexing " + count + " realms under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            for (int page = 1; page <= count / 500 + 1; ++page) {
                for (String realm : this.realmDAO.findAllKeys(page, 500)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(realm)).document((Object)this.utils.document(this.realmDAO.find(realm)))));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Integer> reindexUsers() throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.USER, this.userSettings(), this.userMapping());
        int count = this.userDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.USER);
        this.setStatus("Indexing " + count + " users under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            for (int page = 1; page <= count / 500 + 1; ++page) {
                for (String user : this.userDAO.findAllKeys(page, 500)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(user)).document((Object)this.utils.document(this.userDAO.find(user)))));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Integer> reindexGroups() throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.GROUP, this.groupSettings(), this.groupMapping());
        int count = this.groupDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.GROUP);
        this.setStatus("Indexing " + count + " groups under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            for (int page = 1; page <= count / 500 + 1; ++page) {
                for (String group : this.groupDAO.findAllKeys(page, 500)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(group)).document((Object)this.utils.document(this.groupDAO.find(group)))));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected Pair<String, Integer> reindexAnyObjects() throws IOException {
        this.indexManager.createAnyIndex(AuthContextUtils.getDomain(), AnyTypeKind.ANY_OBJECT, this.anyObjectSettings(), this.anyObjectMapping());
        int count = this.anyObjectDAO.count();
        String index = ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)AnyTypeKind.ANY_OBJECT);
        this.setStatus("Indexing " + count + " any objects under " + index + "...");
        try (BulkIngester ingester = BulkIngester.of(b -> b.client(this.client).maxOperations(500).listener((BulkListener)ErrorLoggingBulkListener.INSTANCE));){
            for (int page = 1; page <= count / 500 + 1; ++page) {
                for (String anyObject : this.anyObjectDAO.findAllKeys(page, 500)) {
                    ingester.add(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(anyObject)).document((Object)this.utils.document(this.anyObjectDAO.find(anyObject)))));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Errors while ingesting index {}", (Object)index, (Object)e);
        }
        return Pair.of((Object)index, (Object)count);
    }

    protected String reindexAudit() throws IOException {
        this.indexManager.createAuditIndex(AuthContextUtils.getDomain(), this.auditSettings(), this.auditMapping());
        return ElasticsearchUtils.getAuditIndex((String)AuthContextUtils.getDomain());
    }

    protected String doExecute(boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        if (!dryRun) {
            this.setStatus("Start rebuilding indexes");
            try {
                Pair<String, Integer> rindex = this.reindexRealms();
                Pair<String, Integer> uindex = this.reindexUsers();
                Pair<String, Integer> gindex = this.reindexGroups();
                Pair<String, Integer> aindex = this.reindexAnyObjects();
                String audit = this.reindexAudit();
                this.setStatus("Rebuild indexes for domain " + AuthContextUtils.getDomain() + " successfully completed");
                return "Indexes created:\n " + (String)rindex.getLeft() + " [" + String.valueOf(rindex.getRight()) + "]\n " + (String)uindex.getLeft() + " [" + String.valueOf(uindex.getRight()) + "]\n " + (String)gindex.getLeft() + " [" + String.valueOf(gindex.getRight()) + "]\n " + (String)aindex.getLeft() + " [" + String.valueOf(aindex.getRight()) + "]\n " + audit;
            }
            catch (Exception e) {
                throw new JobExecutionException("While rebuilding index for domain " + AuthContextUtils.getDomain(), (Throwable)e);
            }
        }
        return "SUCCESS";
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }

    protected static class ErrorLoggingBulkListener
    implements BulkListener<Void> {
        protected static final ErrorLoggingBulkListener INSTANCE = new ErrorLoggingBulkListener();

        protected ErrorLoggingBulkListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request, List<Void> contexts) {
        }

        public void afterBulk(long executionId, BulkRequest request, List<Void> contexts, BulkResponse response) {
            if (response.errors()) {
                String details = response.items().stream().map(BulkResponseItem::error).filter(Objects::nonNull).map(ErrorCause::toString).collect(Collectors.joining(", "));
                AbstractSchedTaskJobDelegate.LOG.error("Errors found for request {}; details: {}", (Object)executionId, (Object)details);
            }
        }

        public void afterBulk(long executionId, BulkRequest request, List<Void> contexts, Throwable failure) {
            AbstractSchedTaskJobDelegate.LOG.error("Bulk request {} failed", (Object)executionId, (Object)failure);
        }
    }
}

