/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.info;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.types.ImplementationType;

@XmlRootElement(name="platformInfo")
@XmlType
public class PlatformInfo
implements Serializable {
    private static final long serialVersionUID = -7941853999417673827L;
    private String version;
    private String buildNumber;
    private ProvisioningInfo provisioningInfo;
    private WorkflowInfo workflowInfo;
    private PersistenceInfo persistenceInfo;
    private boolean selfRegAllowed;
    private boolean pwdResetAllowed;
    private boolean pwdResetRequiringSecurityQuestions;
    private final Set<String> connIdLocations = new HashSet<String>();
    private String passwordGenerator;
    private final List<String> anyTypes = new ArrayList<String>();
    private final List<String> userClasses = new ArrayList<String>();
    private final List<String> anyTypeClasses = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Set<String> entitlements = new HashSet<String>();
    private final Set<JavaImplInfo> javaImplInfos = new HashSet<JavaImplInfo>();

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public ProvisioningInfo getProvisioningInfo() {
        return this.provisioningInfo;
    }

    public void setProvisioningInfo(ProvisioningInfo provisioningInfo) {
        this.provisioningInfo = provisioningInfo;
    }

    public WorkflowInfo getWorkflowInfo() {
        return this.workflowInfo;
    }

    public void setWorkflowInfo(WorkflowInfo workflowInfo) {
        this.workflowInfo = workflowInfo;
    }

    public PersistenceInfo getPersistenceInfo() {
        return this.persistenceInfo;
    }

    public void setPersistenceInfo(PersistenceInfo persistenceInfo) {
        this.persistenceInfo = persistenceInfo;
    }

    public boolean isSelfRegAllowed() {
        return this.selfRegAllowed;
    }

    public boolean isPwdResetAllowed() {
        return this.pwdResetAllowed;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return this.pwdResetRequiringSecurityQuestions;
    }

    @XmlElementWrapper(name="connIdLocations")
    @XmlElement(name="connIdLocation")
    @JsonProperty(value="connIdLocations")
    public Set<String> getConnIdLocations() {
        return this.connIdLocations;
    }

    public String getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(String passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    @XmlElementWrapper(name="anyTypes")
    @XmlElement(name="anyType")
    @JsonProperty(value="anyTypes")
    public List<String> getAnyTypes() {
        return this.anyTypes;
    }

    @XmlElementWrapper(name="userClasses")
    @XmlElement(name="userClass")
    @JsonProperty(value="userClasses")
    public List<String> getUserClasses() {
        return this.userClasses;
    }

    @XmlElementWrapper(name="anyTypeClasses")
    @XmlElement(name="anyTypeClass")
    @JsonProperty(value="anyTypeClasses")
    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @XmlElementWrapper(name="entitlements")
    @XmlElement(name="entitlement")
    @JsonProperty(value="entitlements")
    public Set<String> getEntitlements() {
        return this.entitlements;
    }

    @JsonIgnore
    public Optional<JavaImplInfo> getJavaImplInfo(ImplementationType type) {
        return this.javaImplInfos.stream().filter(javaImplInfo -> javaImplInfo.getType() == type).findFirst();
    }

    @XmlElementWrapper(name="javaImplInfos")
    @XmlElement(name="javaImplInfo")
    @JsonProperty(value="javaImplInfos")
    public Set<JavaImplInfo> getJavaImplInfos() {
        return this.javaImplInfos;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setSelfRegAllowed(boolean selfRegAllowed) {
        this.selfRegAllowed = selfRegAllowed;
    }

    public void setPwdResetAllowed(boolean pwdResetAllowed) {
        this.pwdResetAllowed = pwdResetAllowed;
    }

    public void setPwdResetRequiringSecurityQuestions(boolean pwdResetRequiringSecurityQuestions) {
        this.pwdResetRequiringSecurityQuestions = pwdResetRequiringSecurityQuestions;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.version).append((Object)this.buildNumber).append((Object)this.provisioningInfo).append((Object)this.workflowInfo).append((Object)this.persistenceInfo).append(this.selfRegAllowed).append(this.pwdResetAllowed).append(this.pwdResetRequiringSecurityQuestions).append(this.connIdLocations).append((Object)this.passwordGenerator).append(this.anyTypes).append(this.userClasses).append(this.anyTypeClasses).append(this.resources).append(this.entitlements).append(this.javaImplInfos).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformInfo other = (PlatformInfo)obj;
        return new EqualsBuilder().append((Object)this.version, (Object)other.version).append((Object)this.buildNumber, (Object)other.buildNumber).append((Object)this.provisioningInfo, (Object)other.provisioningInfo).append((Object)this.workflowInfo, (Object)other.workflowInfo).append((Object)this.persistenceInfo, (Object)other.persistenceInfo).append(this.selfRegAllowed, other.selfRegAllowed).append(this.pwdResetAllowed, other.pwdResetAllowed).append(this.pwdResetRequiringSecurityQuestions, other.pwdResetRequiringSecurityQuestions).append(this.connIdLocations, other.connIdLocations).append((Object)this.passwordGenerator, (Object)other.passwordGenerator).append(this.anyTypes, other.anyTypes).append(this.userClasses, other.userClasses).append(this.anyTypeClasses, other.anyTypeClasses).append(this.resources, other.resources).append(this.entitlements, other.entitlements).append(this.javaImplInfos, other.javaImplInfos).build();
    }

    @XmlRootElement(name="persistenceInfo")
    @XmlType
    public static class PersistenceInfo
    implements Serializable {
        private static final long serialVersionUID = 2902980556801069487L;
        private String entityFactory;
        private String plainSchemaDAO;
        private String plainAttrDAO;
        private String plainAttrValueDAO;
        private String anySearchDAO;
        private String userDAO;
        private String groupDAO;
        private String anyObjectDAO;
        private String confDAO;

        public String getEntityFactory() {
            return this.entityFactory;
        }

        public void setEntityFactory(String entityFactory) {
            this.entityFactory = entityFactory;
        }

        public String getPlainSchemaDAO() {
            return this.plainSchemaDAO;
        }

        public void setPlainSchemaDAO(String plainSchemaDAO) {
            this.plainSchemaDAO = plainSchemaDAO;
        }

        public String getPlainAttrDAO() {
            return this.plainAttrDAO;
        }

        public void setPlainAttrDAO(String plainAttrDAO) {
            this.plainAttrDAO = plainAttrDAO;
        }

        public String getPlainAttrValueDAO() {
            return this.plainAttrValueDAO;
        }

        public void setPlainAttrValueDAO(String plainAttrValueDAO) {
            this.plainAttrValueDAO = plainAttrValueDAO;
        }

        public String getAnySearchDAO() {
            return this.anySearchDAO;
        }

        public void setAnySearchDAO(String anySearchDAO) {
            this.anySearchDAO = anySearchDAO;
        }

        public String getUserDAO() {
            return this.userDAO;
        }

        public void setUserDAO(String userDAO) {
            this.userDAO = userDAO;
        }

        public String getGroupDAO() {
            return this.groupDAO;
        }

        public void setGroupDAO(String groupDAO) {
            this.groupDAO = groupDAO;
        }

        public String getAnyObjectDAO() {
            return this.anyObjectDAO;
        }

        public void setAnyObjectDAO(String anyObjectDAO) {
            this.anyObjectDAO = anyObjectDAO;
        }

        public String getConfDAO() {
            return this.confDAO;
        }

        public void setConfDAO(String confDAO) {
            this.confDAO = confDAO;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.entityFactory).append((Object)this.plainSchemaDAO).append((Object)this.plainAttrDAO).append((Object)this.plainAttrValueDAO).append((Object)this.anySearchDAO).append((Object)this.userDAO).append((Object)this.groupDAO).append((Object)this.anyObjectDAO).append((Object)this.confDAO).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PersistenceInfo other = (PersistenceInfo)obj;
            return new EqualsBuilder().append((Object)this.entityFactory, (Object)other.entityFactory).append((Object)this.plainSchemaDAO, (Object)other.plainSchemaDAO).append((Object)this.plainAttrDAO, (Object)other.plainAttrDAO).append((Object)this.plainAttrValueDAO, (Object)other.plainAttrValueDAO).append((Object)this.anySearchDAO, (Object)other.anySearchDAO).append((Object)this.userDAO, (Object)other.userDAO).append((Object)this.groupDAO, (Object)other.groupDAO).append((Object)this.anyObjectDAO, (Object)other.anyObjectDAO).append((Object)this.confDAO, (Object)other.confDAO).build();
        }
    }

    @XmlRootElement(name="workflowInfo")
    @XmlType
    public static class WorkflowInfo
    implements Serializable {
        private static final long serialVersionUID = 6736937721099195324L;
        private String anyObjectWorkflowAdapter;
        private String userWorkflowAdapter;
        private String groupWorkflowAdapter;

        public String getAnyObjectWorkflowAdapter() {
            return this.anyObjectWorkflowAdapter;
        }

        public void setAnyObjectWorkflowAdapter(String anyObjectWorkflowAdapter) {
            this.anyObjectWorkflowAdapter = anyObjectWorkflowAdapter;
        }

        public String getUserWorkflowAdapter() {
            return this.userWorkflowAdapter;
        }

        public void setUserWorkflowAdapter(String userWorkflowAdapter) {
            this.userWorkflowAdapter = userWorkflowAdapter;
        }

        public String getGroupWorkflowAdapter() {
            return this.groupWorkflowAdapter;
        }

        public void setGroupWorkflowAdapter(String groupWorkflowAdapter) {
            this.groupWorkflowAdapter = groupWorkflowAdapter;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.anyObjectWorkflowAdapter).append((Object)this.userWorkflowAdapter).append((Object)this.groupWorkflowAdapter).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkflowInfo other = (WorkflowInfo)obj;
            return new EqualsBuilder().append((Object)this.anyObjectWorkflowAdapter, (Object)other.anyObjectWorkflowAdapter).append((Object)this.userWorkflowAdapter, (Object)other.userWorkflowAdapter).append((Object)this.groupWorkflowAdapter, (Object)other.groupWorkflowAdapter).build();
        }
    }

    @XmlRootElement(name="provisioningInfo")
    @XmlType
    public static class ProvisioningInfo
    implements Serializable {
        private static final long serialVersionUID = 533340357732839568L;
        private String propagationTaskExecutor;
        private String virAttrCache;
        private String anyObjectProvisioningManager;
        private String userProvisioningManager;
        private String groupProvisioningManager;
        private String notificationManager;
        private String auditManager;

        public String getPropagationTaskExecutor() {
            return this.propagationTaskExecutor;
        }

        public void setPropagationTaskExecutor(String propagationTaskExecutor) {
            this.propagationTaskExecutor = propagationTaskExecutor;
        }

        public String getVirAttrCache() {
            return this.virAttrCache;
        }

        public void setVirAttrCache(String virAttrCache) {
            this.virAttrCache = virAttrCache;
        }

        public String getAnyObjectProvisioningManager() {
            return this.anyObjectProvisioningManager;
        }

        public void setAnyObjectProvisioningManager(String anyObjectProvisioningManager) {
            this.anyObjectProvisioningManager = anyObjectProvisioningManager;
        }

        public String getUserProvisioningManager() {
            return this.userProvisioningManager;
        }

        public void setUserProvisioningManager(String userProvisioningManager) {
            this.userProvisioningManager = userProvisioningManager;
        }

        public String getGroupProvisioningManager() {
            return this.groupProvisioningManager;
        }

        public void setGroupProvisioningManager(String groupProvisioningManager) {
            this.groupProvisioningManager = groupProvisioningManager;
        }

        public String getNotificationManager() {
            return this.notificationManager;
        }

        public void setNotificationManager(String notificationManager) {
            this.notificationManager = notificationManager;
        }

        public String getAuditManager() {
            return this.auditManager;
        }

        public void setAuditManager(String auditManager) {
            this.auditManager = auditManager;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.propagationTaskExecutor).append((Object)this.virAttrCache).append((Object)this.anyObjectProvisioningManager).append((Object)this.userProvisioningManager).append((Object)this.groupProvisioningManager).append((Object)this.notificationManager).append((Object)this.auditManager).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProvisioningInfo other = (ProvisioningInfo)obj;
            return new EqualsBuilder().append((Object)this.propagationTaskExecutor, (Object)other.propagationTaskExecutor).append((Object)this.virAttrCache, (Object)other.virAttrCache).append((Object)this.anyObjectProvisioningManager, (Object)other.anyObjectProvisioningManager).append((Object)this.userProvisioningManager, (Object)other.userProvisioningManager).append((Object)this.groupProvisioningManager, (Object)other.groupProvisioningManager).append((Object)this.notificationManager, (Object)other.notificationManager).append((Object)this.auditManager, (Object)other.auditManager).build();
        }
    }
}

