/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;

@XmlType
@XmlSeeAlso(value={UserTO.class, GroupTO.class, AnyObjectTO.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@class")
@JsonPropertyOrder(value={"@class", "key", "type", "realm", "username", "name"})
@Schema(subTypes={UserTO.class, GroupTO.class, AnyObjectTO.class}, discriminatorProperty="@class")
public abstract class AnyTO
extends AbstractAnnotatedBean
implements EntityTO,
AttributableTO {
    private static final long serialVersionUID = -754311920679872084L;
    @XmlTransient
    @JsonProperty(value="@class")
    private String discriminator;
    private String key;
    private String type;
    private String realm;
    private final List<String> dynRealms = new ArrayList<String>();
    private String status;
    private final List<String> auxClasses = new ArrayList<String>();
    private final Set<AttrTO> plainAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();
    private final Set<String> resources = new HashSet<String>();

    @Schema(name="@class", required=true)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    @Override
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @XmlElementWrapper(name="dynRealms")
    @XmlElement(name="dynRealmF")
    @JsonProperty(value="dynRealms")
    public List<String> getDynRealms() {
        return this.dynRealms;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlElementWrapper(name="auxClasses")
    @XmlElement(name="class")
    @JsonProperty(value="auxClasses")
    public List<String> getAuxClasses() {
        return this.auxClasses;
    }

    @Override
    @XmlElementWrapper(name="plainAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="plainAttrs")
    public Set<AttrTO> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @XmlElementWrapper(name="derAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="derAttrs")
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getDerAttr(String schema) {
        return this.derAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @XmlElementWrapper(name="virAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="virAttrs")
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getVirAttr(String schema) {
        return this.virAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public Set<String> getResources() {
        return this.resources;
    }
}

