/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_class")
@JsonPropertyOrder(value={"_class", "key"})
public abstract class Domain
implements Serializable {
    private static final long serialVersionUID = -5881851479361505961L;
    private static final Logger LOG = LoggerFactory.getLogger(Domain.class);
    protected String key;
    protected String adminPassword;
    protected CipherAlgorithm adminCipherAlgorithm = CipherAlgorithm.SHA512;
    protected String content;
    protected String keymasterConfParams;
    protected boolean deployed = false;

    protected static String read(String filename) {
        String read = null;
        try {
            read = IOUtils.toString((InputStream)Domain.class.getResourceAsStream("/" + filename));
        }
        catch (IOException e) {
            LOG.error("Could not read {}", (Object)filename, (Object)e);
        }
        return read;
    }

    @JsonProperty(value="_class")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public void setDiscriminator(String discriminator) {
    }

    public String getKey() {
        return this.key;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public CipherAlgorithm getAdminCipherAlgorithm() {
        return this.adminCipherAlgorithm;
    }

    public void setAdminCipherAlgorithm(CipherAlgorithm adminCipherAlgorithm) {
        this.adminCipherAlgorithm = adminCipherAlgorithm;
    }

    protected abstract String defaultContentFile();

    public String getContent() {
        if (this.content == null) {
            this.content = Domain.read(this.defaultContentFile());
        }
        return this.content;
    }

    public String getKeymasterConfParams() {
        if (this.keymasterConfParams == null) {
            this.keymasterConfParams = Domain.read("defaultKeymasterConfParams.json");
        }
        return this.keymasterConfParams;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.adminPassword).append((Object)this.adminCipherAlgorithm).append((Object)this.content).append((Object)this.keymasterConfParams).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.adminPassword, (Object)other.adminPassword).append((Object)this.adminCipherAlgorithm, (Object)other.adminCipherAlgorithm).append((Object)this.content, (Object)other.content).append((Object)this.keymasterConfParams, (Object)other.keymasterConfParams).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.key).append((Object)this.adminPassword).append((Object)this.adminCipherAlgorithm).append((Object)this.content).append((Object)this.keymasterConfParams).build();
    }

    protected static abstract class Builder<D extends Domain, B extends Builder<D, B>> {
        protected final D domain;

        Builder(D domain, String key) {
            this.domain = domain;
            ((Domain)this.domain).key = key;
        }

        public B adminPassword(String adminPassword) {
            ((Domain)this.domain).adminPassword = adminPassword;
            return (B)this;
        }

        public B adminCipherAlgorithm(CipherAlgorithm adminCipherAlgorithm) {
            ((Domain)this.domain).adminCipherAlgorithm = adminCipherAlgorithm;
            return (B)this;
        }

        public B content(String content) {
            ((Domain)this.domain).content = content;
            return (B)this;
        }

        public B keymasterConfParams(String keymasterConfParams) {
            ((Domain)this.domain).keymasterConfParams = keymasterConfParams;
            return (B)this;
        }

        public D build() {
            return this.domain;
        }
    }
}

