/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public abstract class BaseUserSelfResource
extends BaseResource {
    private static final long serialVersionUID = -5892402817902884085L;

    protected void dateToMillis(Set<AttrTO> attrs, PlainSchemaTO plainSchema) throws ParseException {
        FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
        attrs.stream().filter(attr -> attr.getSchema().equals(plainSchema.getKey())).forEachOrdered(attr -> {
            ListIterator<String> itor = attr.getValues().listIterator();
            while (itor.hasNext()) {
                String value = (String)itor.next();
                try {
                    itor.set(String.valueOf(fmt.parse(value).getTime()));
                }
                catch (ParseException ex) {
                    LOG.error("Unable to parse date {}", (Object)value);
                }
            }
        });
    }

    protected void millisToDate(Set<AttrTO> attrs, PlainSchemaTO plainSchema) throws IllegalArgumentException {
        FastDateFormat fmt = FastDateFormat.getInstance((String)plainSchema.getConversionPattern());
        attrs.stream().filter(attr -> attr.getSchema().equals(plainSchema.getKey())).forEachOrdered(attr -> {
            ListIterator<String> itor = attr.getValues().listIterator();
            while (itor.hasNext()) {
                String value = (String)itor.next();
                try {
                    itor.set(fmt.format((Object)Long.valueOf(value)));
                }
                catch (NumberFormatException ex) {
                    LOG.error("Invalid format value for {}", (Object)value);
                }
            }
        });
    }

    protected void buildResponse(AbstractResource.ResourceResponse response, int statusCode, final String message) {
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        response.setStatusCode(Integer.valueOf(statusCode));
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)message);
            }
        });
    }
}

